/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import utils.ostools.OS;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHTextFieldBorder;
import utils.swing.customlaf.SHUI;
import utils.swing.icons.SystemIconUtil;
import utils.swing.images.ImageLoader;
import utils.swing.seaglass.MacKeybindings;

public class SimpleHelpLookAndFeel
extends BasicLookAndFeel {
    private UIDefaults uiDefaults;
    private HashMap<String, String> colorMap = new HashMap();
    private Border zeroEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private Object fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
    private Object multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
    private Object formattedInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"});
    private static double scaling = 1.0;

    public static boolean isHDPI() {
        return OS.isMacOS() && OS.isOSXRetina() || SimpleHelpLookAndFeel.getScalingFactor() > 1.2;
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        return ImageLoader.getDisabledVersionOf(icon);
    }

    @Override
    public String getName() {
        return "SimpleHelp L&F";
    }

    @Override
    public String getID() {
        return "shlf";
    }

    @Override
    public String getDescription() {
        return "The SimpleHelp look and feel.";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        this.uiDefaults = table;
        super.initClassDefaults(table);
        table.put("ButtonUI", "utils.swing.customlaf.SHButtonUI");
        table.put("CheckBoxUI", "utils.swing.customlaf.SHCheckBoxUI");
        table.put("TextFieldUI", "utils.swing.customlaf.SHTextFieldUI");
        table.put("FormattedTextFieldUI", "utils.swing.customlaf.SHTextFieldUI");
        table.put("PasswordFieldUI", "utils.swing.customlaf.SHPasswordFieldUI");
        table.put("PasswordTextFieldUI", "utils.swing.customlaf.SHPasswordFieldUI");
        table.put("SliderUI", "utils.swing.customlaf.SHSliderUI");
        table.put("MenuBarUI", "utils.swing.customlaf.SHMenuBarUI");
        table.put("MenuItemUI", "utils.swing.customlaf.SHMenuItemUI");
        table.put("CheckBoxMenuItemUI", "utils.swing.customlaf.SHMenuItemUI");
        table.put("TableHeaderUI", "utils.swing.customlaf.SHTableHeaderUI");
        table.put("ScrollBarUI", "utils.swing.customlaf.SHScrollBarUI");
        table.put("TabbedPaneUI", "utils.swing.customlaf.SHTabbedPaneUI");
        table.put("ToggleButtonUI", "utils.swing.customlaf.SHToggleButtonUI");
        table.put("ScrollPaneUI", "utils.swing.customlaf.SHScrollPaneUI");
        table.put("InternalFrameUI", "utils.swing.customlaf.SHInternalFrameUI");
        table.put("RadioButtonUI", "utils.swing.customlaf.SHRadioButtonUI");
        table.put("ComboBoxUI", "utils.swing.customlaf.SHComboBoxUI");
        table.put("ListUI", "utils.swing.customlaf.SHListUI");
        table.put("SeparatorUI", "utils.swing.customlaf.SHSeparatorUI");
        table.put("SplitPaneUI", "utils.swing.customlaf.SHSplitPaneUI");
        table.put("FileChooserUI", "utils.swing.customlaf.SHFileChooserBasicUI");
        table.put("TableUI", "utils.swing.customlaf.SHTableUI");
        table.put("Table.alternateRowColor", new Color(245, 245, 245));
        table.put("ProgressBarUI", "utils.swing.customlaf.SHProgressBarUI");
        table.put("PanelUI", "javax.swing.plaf.basic.BasicPanelUI");
        table.put("ToolBarUI", "javax.swing.plaf.basic.BasicToolBarUI");
        table.put("MenuUI", "javax.swing.plaf.basic.BasicMenuUI");
        table.put("RadioButtonMenuItemUI", "javax.swing.plaf.basic.BasicRadioButtonMenuItemUI");
        table.put("DesktopIconUI", "javax.swing.plaf.basic.BasicDesktopIconUI");
        table.put("PopupMenuSeparatorUI", "javax.swing.plaf.basic.BasicPopupMenuSeparatorUI");
        table.put("RootPaneUI", "javax.swing.plaf.basic.BasicRootPaneUI");
        table.put("OptionPaneUI", "javax.swing.plaf.basic.BasicOptionPaneUI");
        table.put("SpinnerUI", "javax.swing.plaf.basic.BasicSpinnerUI");
    }

    private InsetsUIResource getButtonMargin() {
        return new InsetsUIResource(4, 12, 4, 12);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        this.colorMap.put("activeBackground", "#3E91EB");
        this.colorMap.put("activeBlend", "#3E91EB");
        this.colorMap.put("activeForeground", "#FFFFFF");
        this.colorMap.put("activeTitleBtnBg", "#AFD6FF");
        this.colorMap.put("alternateBackground", "#EEF6FF");
        this.colorMap.put("background", "#F6F5F4");
        this.colorMap.put("buttonBackground", "#D7E7F9");
        this.colorMap.put("buttonForeground", "#000000");
        this.colorMap.put("foreground", "#000000");
        this.colorMap.put("inactiveBackground", "#AFD6FF");
        this.colorMap.put("inactiveBlend", "#AFD6FF");
        this.colorMap.put("inactiveForeground", "#232323");
        this.colorMap.put("inactiveTitleBtnBg", "#DAEEFF");
        this.colorMap.put("linkColor", "#0000C0");
        this.colorMap.put("selectBackground", "#A9D1FF");
        this.colorMap.put("selectForeground", "#030303");
        this.colorMap.put("visitedLinkColor", "#800080");
        this.colorMap.put("windowBackground", "#FFFFFF");
        this.colorMap.put("windowForeground", "#000000");
        String[] defaultSystemColors = new String[]{"desktop", this.colorMap.get("alternateBackground"), "activeCaption", this.colorMap.get("activeBackground"), "activeCaptionText", this.colorMap.get("activeForeground"), "activeCaptionBorder", this.colorMap.get("activeBackground"), "inactiveCaption", this.colorMap.get("inactiveBackground"), "inactiveCaptionText", this.colorMap.get("inactiveForeground"), "inactiveCaptionBorder", this.colorMap.get("inactiveBackground"), "window", this.colorMap.get("background"), "windowBorder", this.colorMap.get("windowBackground"), "windowText", this.colorMap.get("windowForeground"), "menu", this.colorMap.get("background"), "menuText", this.colorMap.get("foreground"), "text", this.colorMap.get("windowBackground"), "textText", this.colorMap.get("windowForeground"), "textHighlight", this.colorMap.get("selectBackground"), "textHighlightText", this.colorMap.get("selectForeground"), "textInactiveText", "#A7A5A3", "control", this.colorMap.get("background"), "controlText", this.colorMap.get("buttonForeground"), "controlHighlight", this.colorMap.get("buttonBackground"), "controlLtHighlight", this.colorMap.get("selectBackground"), "controlShadow", "#BBBBBB", "controlLightShadow", "#000000", "controlDkShadow", "#000000", "scrollbar", "#000000", "info", this.colorMap.get("foreground"), "infoText", this.colorMap.get("foreground")};
        this.loadSystemColors(table, defaultSystemColors, false);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        table.put("textHighlightText", Color.decode("#FFFFFF"));
        Border redWarning = SHBorderFactory.createLineBorder(Color.red);
        super.initComponentDefaults(table);
        Border emptyOneBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        SHTextFieldBorder textFieldBorder = new SHTextFieldBorder();
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        table.put("Button.margin", this.getButtonMargin());
        table.put("Button.border", marginBorder);
        table.put("ToggleButton.margin", this.getButtonMargin());
        table.put("ToggleButton.border", marginBorder);
        table.put("ToggleButton.background", table.get("window"));
        table.put("TextField.border", textFieldBorder);
        table.put("PasswordField.border", textFieldBorder);
        table.put("Spinner.border", textFieldBorder);
        table.put("ToolBar.background", table.get("window"));
        table.put("MenuBar.background", table.get("window"));
        EmptyBorder border = new EmptyBorder(2, 2, 2, 2);
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", border);
        border = new EmptyBorder(3, 1, 3, 1);
        table.put("Menu.border", border);
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("Menu.submenuPopupOffsetX", (Object)-3);
        table.put("Menu.submenuPopupOffsetY", (Object)4);
        table.put("PopupMenu.border", SHBorderFactory.createLineBorder(SHUI.POPUP_BORDER, 1));
        table.put("SplitPane.dividerSize", (Object)7);
        table.put("InternalFrame.paletteTitleHeight", (Object)18);
        table.put("InternalFrame.frameTitleHeight", (Object)22);
        table.put("InternalFrame.paletteTitleFont", this.getFont(0, 12, false));
        table.put("InternalFrame.titleFont", this.getFont(0, 13, false));
        table.put("InternalFrame.pantherTitleFont", this.getFont(0, 13, false));
        table.put("InternalFrame.activeTitleForeground", new Color(50, 50, 50));
        table.put("InternalFrame.icon", (Object)null);
        table.put("Panel.background", table.get("window"));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(1, 1, 1, 1));
        table.put("TabbedPane.tabAreaInsets", new Insets(4, 2, 0, 0));
        table.put("TabbedPane.contentBorderInsets", new Insets(5, 0, 0, 0));
        table.put("TabbedPane.unselected", table.get("shadow"));
        table.put("TabbedPane.tabsOverlapBorder", Boolean.TRUE);
        table.put("Checkbox.select", table.get("shadow"));
        table.put("PopupMenu.background", SHUI.POPUP_BACKGROUND);
        table.put("PopupMenu.foreground", Color.black);
        table.put("TextField.selectionForeground", table.get("textHighlightText"));
        table.put("TextField.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("TextField.background", table.get("text"));
        table.put("TextField.focusInputMap", this.fieldInputMap);
        table.put("TextArea.disabledBackground", new ColorUIResource(new Color(250, 250, 250)));
        table.put("TextField.disabledBackground", new ColorUIResource(new Color(250, 250, 250)));
        table.put("PasswordField.disabledBackground", new ColorUIResource(new Color(250, 250, 250)));
        table.put("PasswordField.focusInputMap", this.fieldInputMap);
        table.put("TextArea.focusInputMap", this.multilineInputMap);
        table.put("TextPane.focusInputMap", this.multilineInputMap);
        table.put("TextPane.background", table.get("text"));
        table.put("EditorPane.focusInputMap", this.multilineInputMap);
        table.put("FormattedTextField.focusInputMap", this.formattedInputMap);
        table.put("List.background", table.get("text"));
        table.put("List.border", this.zeroEmptyBorder);
        table.put("List.selectionForeground", table.get("textHighlightText"));
        table.put("List.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("List.focusCellHighlightBorder", emptyOneBorder);
        table.put("ScrollPane.border", SHBorderFactory.createLineBorder(SHStyle.BORDER_COLOR));
        table.put("Table.border", SHBorderFactory.createLineBorder(SHStyle.BORDER_COLOR));
        table.put("ComboBox.border", this.zeroEmptyBorder);
        table.put("ComboBox.background", table.get("text"));
        table.put("ComboBox.selectionForeground", table.get("textHighlightText"));
        table.put("ComboBox.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}));
        table.put("Table.background", table.get("text"));
        table.put("Table.foreground", table.get("controlText"));
        table.put("Table.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("Table.selectionForeground", table.get("textHighlightText"));
        table.put("Table.focusCellBackground", table.get("textHighlight"));
        table.put("Table.focusCellForeground", table.get("textHighlightText"));
        table.put("Table.focusCellHighlightBorder", emptyOneBorder);
        table.put("TableHeader.font", this.getFont(0, 12, false));
        table.put("TableHeader.foreground", table.get("textText"));
        table.put("TableHeader.background", SHStyle.PANEL_BACKGROUND_LIGHT);
        table.put("TableHeader.cellBorder", this.zeroEmptyBorder);
        table.put("ToolTip.background", new Color(255, 255, 225));
        table.put("ToolTip.foreground", new Color(0, 0, 0));
        table.put("ToolTip.font", this.getFont(0, 12, false));
        table.put("ToolTip.border", new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
        table.put("Tree.font", this.getFont(0, 12, false));
        table.put("Tree.selectionForeground", table.get("textHighlightText"));
        table.put("Tree.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("Tree.foreground", table.get("textText"));
        table.put("Tree.background", table.get("text"));
        table.put("Tree.hash", table.get("text"));
        table.put("Tree.rowHeight", new Integer(18));
        table.put("Tree.selectionBorderColor", new Color(86, 46, 0));
        table.put("SplitPane.background", table.get("text"));
        table.put("SplitPane.border", redWarning);
        table.put("SplitPaneDivider.border", this.zeroEmptyBorder);
        table.put("ProgressBar.horizontalSize", new Dimension(146, 14));
        table.put("ProgressBar.verticalSize", new Dimension(14, 146));
        table.put("ProgressBar.font", this.getFont(0, 12, false));
        table.put("ProgressBar.background", SHUI.BUTTON_GREEN.getDisabledTop());
        table.put("ProgressBar.foreground", SHUI.BUTTON_BLUE.bottom);
        table.put("ProgressBar.selectionBackground", SHUI.BUTTON_BLUE.border);
        table.put("ProgressBar.selectionForeground", SHUI.BUTTON_BLUE.border.darker());
        table.put("ProgressBar.border", SHBorderFactory.createLineBorder(SHUI.BUTTON_NORMAL.getDisabledBorder()));
        table.put("TextArea.border", emptyOneBorder);
        table.put("TextArea.background", table.get("TextField.background"));
        table.put("PasswordField.background", table.get("TextField.background"));
        table.put("TextArea.font", table.get("TextField.font"));
        table.put("Menu.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("TextArea.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("Separator.background", SHUI.POPUP_BACKGROUND);
        if (OS.isWindows()) {
            this.installWindowsKeyBindings(this.uiDefaults);
        } else if (OS.isMacOS()) {
            MacKeybindings.installKeybindings(this.uiDefaults);
        } else {
            this.installLinuxKeyBindings(this.uiDefaults);
        }
        table.put("TextArea.selectionForeground", table.get("textHighlightText"));
        table.put("Menu.selectionForeground", table.get("textHighlightText"));
        table.put("MenuItem.checkIcon", new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"/utils/swing/customlaf/images/menuchecked.png"}));
        table.put("FileView.directoryIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"));
        table.put("FileView.fileIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"));
        table.put("FileView.hardDriveIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeHardDriveIcon"));
        table.put("FileView.computerIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeComputerIcon"));
        table.put("FileView.floppyDriveIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFloppyDriveIcon"));
        table.put("FileChooser.detailsViewIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserDetailViewIcon"));
        table.put("FileChooser.homeFolderIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserHomeFolderIcon"));
        table.put("FileChooser.listViewIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserListViewIcon"));
        table.put("FileChooser.newFolderIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserNewFolderIcon"));
        table.put("FileChooser.upFolderIcon", new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserUpFolderIcon"));
        table.put("ComboBox.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("Tree.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("Table.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("List.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("Menu.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("TextField.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("PasswordField.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("TextArea.selectionBackground", SHStyle.SELECTION_BACKGROUND);
        table.put("ComboBox.selectionForeground", Color.WHITE);
        table.put("Tree.selectionForeground", Color.WHITE);
        table.put("Table.selectionForeground", Color.WHITE);
        table.put("List.selectionForeground", Color.WHITE);
        table.put("Menu.selectionForeground", Color.WHITE);
        table.put("TextField.selectionForeground", Color.WHITE);
        table.put("PasswordField.selectionForeground", Color.WHITE);
        table.put("TextArea.selectionForeground", Color.WHITE);
        table.put("desktop", SHStyle.TABLE_ROW_BAND_COLOR);
        UIManager.put("OptionPane.yesButtonMnemonic", "0");
        UIManager.put("OptionPane.noButtonMnemonic", "0");
        UIManager.put("OptionPane.okButtonMnemonic", "0");
        UIManager.put("OptionPane.cancelButtonMnemonic", "0");
        table.put("Tree.editorBorder", SHBorderFactory.createEmptyBorder());
        SHLazyValue right = null;
        SHLazyValue down = null;
        if (ImageLoader.canLoad("svg")) {
            right = new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"images/svg/arrows/blue-right.svg,10"});
            down = new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"images/svg/arrows/blue-down.svg,10"});
        } else {
            down = new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeControlIcon", new Object[]{false});
            right = new SHLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeControlIcon", new Object[]{true});
        }
        table.put("Tree.collapsedIcon", right);
        table.put("Tree.expandedIcon", down);
    }

    protected Font getFont(int type, int size, boolean scale) {
        if (scale) {
            size = SimpleHelpLookAndFeel.scale(size);
        }
        if (OS.isMacOS()) {
            return new Font("Helvetica", type, size);
        }
        return new Font("Lucida Sans", type, size);
    }

    public static Font getFont(float sizePts) {
        return SimpleHelpLookAndFeel.getFont(sizePts, true);
    }

    private static Font getFont(float sizePts, boolean scale) {
        if (scale) {
            sizePts = SimpleHelpLookAndFeel.scale(sizePts);
        }
        if (OS.isMacOS()) {
            return new Font("Helvetica", 0, 10).deriveFont(sizePts);
        }
        return new Font("Lucida Sans", 0, 10).deriveFont(sizePts);
    }

    private void installWindowsKeyBindings(UIDefaults uiDefaults) {
        try {
            Class<?> clazz = Class.forName("sun.swing.plaf.WindowsKeybindings");
            Method method = clazz.getMethod("installKeybindings", UIDefaults.class);
            method.invoke(null, uiDefaults);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void installLinuxKeyBindings(UIDefaults uiDefaults) {
        try {
            Class<?> clazz = Class.forName("sun.swing.plaf.GTKKeybindings");
            Method method = clazz.getMethod("installKeybindings", UIDefaults.class);
            method.invoke(null, uiDefaults);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void postSetupPickIcons() {
        if (ImageLoader.canLoad("svg")) {
            UIManager.put("FileChooser.detailsViewIcon", new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"images/svg/files-folders/files-grid.svg,16"}));
            UIManager.put("FileChooser.listViewIcon", new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"images/svg/files-folders/files-list.svg,16"}));
            UIManager.put("FileChooser.homeFolderIcon", new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"images/svg/general/home.svg,16"}));
            UIManager.put("FileChooser.newFolderIcon", new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"images/svg/files-folders/folder-new.svg,16"}));
            UIManager.put("FileChooser.upFolderIcon", new SHLazyValue("utils.swing.images.ImageLoader", "getImageIcon", new Object[]{"images/svg/files-folders/folder-up.svg,16"}));
        }
        try {
            UIManager.put("FileView.directoryIcon", SystemIconUtil.getDefaultFolderIcon());
            UIManager.put("FileView.fileIcon", SystemIconUtil.getDefaultFileIcon());
            UIManager.put("FileView.hardDriveIcon", SystemIconUtil.getDefaultDriveIcon());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void setScaling(int scalingPercentage) {
        scaling = (double)scalingPercentage / 100.0;
        if (!ImageLoader.isScaling()) {
            ImageLoader.setScaling(scalingPercentage);
            SHUI.TEXT_FIELD_HEIGHT = (int)((double)SHUI.TEXT_FIELD_HEIGHT * scaling);
        } else {
            SimpleHelpLookAndFeel.updateDefaultsForNewScalingFactor();
        }
    }

    public static double getScalingFactor() {
        return scaling;
    }

    public static float scale(float sizePts) {
        return (float)((double)sizePts * scaling);
    }

    public static int scale(int i) {
        return (int)((double)i * scaling);
    }

    public static int unscale(int i) {
        return (int)((double)i / scaling);
    }

    public static Dimension scale(Dimension i) {
        i.width = (int)((double)i.width * scaling);
        i.height = (int)((double)i.height * scaling);
        return i;
    }

    public static InsetsUIResource scale(Insets i) {
        return new InsetsUIResource((int)((double)i.top * scaling), (int)((double)i.left * scaling), (int)((double)i.bottom * scaling), (int)((double)i.right * scaling));
    }

    public static int[] scale(int[] ints) {
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = SimpleHelpLookAndFeel.scale(ints[i]);
        }
        return ints;
    }

    public static Dimension scaledDimension(int w, int h) {
        return new Dimension(w, h);
    }

    private static void updateDefaultsForNewScalingFactor() {
        Object[] keys;
        UIDefaults currentDefaults = UIManager.getLookAndFeelDefaults();
        for (Object key : keys = currentDefaults.keySet().toArray(new Object[0])) {
            Object value = currentDefaults.get(key);
            if (value instanceof Rescaleable) {
                ((Rescaleable)value).rescale();
            } else if (value instanceof Integer) {
                boolean change;
                String lcKey = key.toString().toLowerCase();
                boolean bl = change = lcKey.contains("width") || lcKey.contains("height") || lcKey.contains("size") || lcKey.contains("gap") || lcKey.contains("indent");
                if (change) {
                    value = SimpleHelpLookAndFeel.scale((Integer)value);
                }
            } else if (value instanceof InsetsUIResource) {
                value = SimpleHelpLookAndFeel.scale((InsetsUIResource)value);
            } else if (value instanceof Font) {
                value = new ScaledFont((Font)value);
            } else if (value instanceof Dimension) {
                value = new ScaledDimension((Dimension)value);
            } else if (value instanceof EmptyBorder) {
                value = new ScaledEmptyBorder((EmptyBorder)value);
            }
            currentDefaults.put(key, value);
        }
    }

    private static interface Rescaleable {
        public void rescale();
    }

    public static class ScaledFont
    extends Font
    implements Rescaleable {
        Font original;

        public ScaledFont(Font original) {
            super(original.getName(), original.getStyle(), SimpleHelpLookAndFeel.scale(original.getSize()));
            this.pointSize = SimpleHelpLookAndFeel.scale(original.getSize2D());
            this.original = original;
        }

        @Override
        public void rescale() {
            this.pointSize = SimpleHelpLookAndFeel.scale(this.original.getSize2D());
        }
    }

    private static class ScaledEmptyBorder
    extends EmptyBorder
    implements Rescaleable {
        EmptyBorder original;

        public ScaledEmptyBorder(EmptyBorder original) {
            super(SimpleHelpLookAndFeel.scale(original.getBorderInsets()));
            this.original = original;
        }

        @Override
        public void rescale() {
            Insets insets = this.original.getBorderInsets();
            this.top = SimpleHelpLookAndFeel.scale(insets.top);
            this.bottom = SimpleHelpLookAndFeel.scale(insets.bottom);
            this.left = SimpleHelpLookAndFeel.scale(insets.left);
            this.right = SimpleHelpLookAndFeel.scale(insets.right);
        }
    }

    private static class ScaledDimension
    extends Dimension
    implements Rescaleable {
        Dimension original;

        public ScaledDimension(Dimension dimension) {
            super(SimpleHelpLookAndFeel.scale(dimension.width), SimpleHelpLookAndFeel.scale(dimension.height));
            this.original = dimension;
        }

        @Override
        public void rescale() {
            this.width = SimpleHelpLookAndFeel.scale(this.original.width);
            this.height = SimpleHelpLookAndFeel.scale(this.original.height);
        }
    }

    public class SHLazyValue
    implements UIDefaults.LazyValue {
        private String className;
        private String methodName;
        private Object[] args;

        public SHLazyValue(String var1) {
            this(var1, (String)null);
        }

        public SHLazyValue(String var1, String var2) {
            this(var1, var2, null);
        }

        public SHLazyValue(String var1, Object[] var2) {
            this(var1, null, var2);
        }

        public SHLazyValue(String var1, String var2, Object[] var3) {
            this.className = var1;
            this.methodName = var2;
            if (var3 != null) {
                this.args = (Object[])var3.clone();
            }
        }

        @Override
        public Object createValue(UIDefaults var1) {
            try {
                Class<?> var2 = Class.forName(this.className);
                if (this.methodName != null) {
                    Class[] var3 = this.getClassArray(this.args);
                    Method var6 = var2.getMethod(this.methodName, var3);
                    this.makeAccessible(var6);
                    return var6.invoke(var2, this.args);
                }
                Class[] var3 = this.getClassArray(this.args);
                Constructor<?> var4 = var2.getConstructor(var3);
                this.makeAccessible(var4);
                return var4.newInstance(this.args);
            }
            catch (Exception var5) {
                return null;
            }
        }

        private void makeAccessible(final AccessibleObject var1) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Void run() {
                    var1.setAccessible(true);
                    return null;
                }
            });
        }

        private Class[] getClassArray(Object[] var1) {
            Class[] var2 = null;
            if (var1 != null) {
                var2 = new Class[var1.length];
                for (int var3 = 0; var3 < var1.length; ++var3) {
                    var2[var3] = var1[var3] instanceof Integer ? Integer.TYPE : (var1[var3] instanceof Boolean ? Boolean.TYPE : (var1[var3] instanceof ColorUIResource ? Color.class : var1[var3].getClass()));
                }
            }
            return var2;
        }
    }
}

