/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Toolkit;
import utils.ostools.OS;

public class ScalingUtil {
    private static final int NO_SCALING_DPI = 96;
    private static int scalingPercentageOverride = -1;

    public static int detectScalingPercetange() {
        if (scalingPercentageOverride > 0) {
            return scalingPercentageOverride;
        }
        try {
            if (OS.isMacOS()) {
                return 100;
            }
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            return dpi * 100 / 96;
        }
        catch (Throwable t) {
            System.out.println("[ScalingUtil] Unable to detect scaling factor (" + t.getClass().getName() + " - " + t.getMessage() + ")");
            return 100;
        }
    }

    public static void forceScalingPercentage(int scalingPercentage) {
        scalingPercentageOverride = scalingPercentage;
    }
}

