/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHTextFieldBorder
extends AbstractBorder
implements UIResource {
    private static final Insets PADDING = SimpleHelpLookAndFeel.scale(new Insets(3, 5, 3, 5));
    private Insets insets;

    public SHTextFieldBorder() {
        this.insets = PADDING;
    }

    public SHTextFieldBorder(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public void setInsets(Insets i) {
        this.insets = i;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(SHButtonUI.getBorderStroke());
        if (c.isEnabled()) {
            g2d.setColor(SHUI.TEXT_BORDER);
        } else {
            g2d.setColor(SHUI.TEXT_BORDER_DISABLED);
        }
        float strokeWidth = SHButtonUI.getBorderStrokeWidth();
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, (float)w - strokeWidth, (float)h - strokeWidth);
        g2d.draw(rect);
    }
}

