/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHTableHeaderUI
extends BasicTableHeaderUI {
    public static final int HEADER_HEIGHT = SimpleHelpLookAndFeel.scale(24);
    private int columnSelected = -1;
    private static final Border headerBorder = SHBorderFactory.createEmptyBorder(0, 3, 0, 3);
    private static final Border emptyBorder = SHBorderFactory.createEmptyBorder(0, 2, 0, 0);
    private static Border lineBorder = null;

    public static ComponentUI createUI(JComponent h) {
        return new SHTableHeaderUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        int columnMargin = cm.getColumnMargin();
        Rectangle cellRect = this.header.getHeaderRect(cMin);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        } else {
            int columnWidth;
            TableColumn aColumn = cm.getColumn(cMin);
            if (aColumn != draggedColumn) {
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x += columnMargin;
                this.paintCell(g, cellRect, cMin);
            }
            for (column = cMin + 1; column <= cMax; ++column) {
                aColumn = cm.getColumn(column);
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x -= columnWidth;
                if (aColumn == draggedColumn) continue;
                this.paintCell(g, cellRect, column);
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        boolean index = false;
        Component component = this.getHeaderRenderer(columnIndex);
        if (columnIndex == this.columnSelected) {
            index = true;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(headerBorder);
        }
        component.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
        component.setFont(SHStyle.smallerFont);
        if (columnIndex > 0) {
            if (lineBorder == null) {
                MatteBorder matteBorder = SHBorderFactory.createMatteBorder(0, 1, 0, 0, SHUI.TABLE_HEADER_BORDER);
                lineBorder = SHBorderFactory.createCompoundBorder(SHBorderFactory.createEmptyBorder(2, 0, 2, 0), SHBorderFactory.createCompoundBorder(matteBorder, emptyBorder));
            }
            lineBorder.paintBorder(component, g, cellRect.x, cellRect.y, cellRect.width, cellRect.height - 1);
        }
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        g.setColor(SHUI.TABLE_HEADER_BORDER);
        g.drawLine(cellRect.x, cellRect.height - 1, cellRect.x + cellRect.width, cellRect.height - 1);
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d = super.getMinimumSize(c);
        d.height = HEADER_HEIGHT;
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        d.height = HEADER_HEIGHT;
        return d;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = super.getMaximumSize(c);
        d.height = HEADER_HEIGHT;
        return d;
    }
}

