/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHUI;

public class SHTabbedPaneUI
extends BasicTabbedPaneUI {
    public static final String BORDER_KEY = "BORDER";
    public static final String BORDER_VALUE_NONE = "NONE";
    public static final String SHADOW_KEY = "SHADOW";
    public static final String SHADOW_VALUE_NONE = "NONE";
    private boolean drawBorders = false;
    private boolean drawShadow = true;
    private Color borderColor = SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, false);

    public SHTabbedPaneUI(boolean drawBorders, boolean drawShadow) {
        this.drawBorders = drawBorders;
        this.drawShadow = drawShadow;
    }

    @Override
    public void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SHTabbedPaneUI(false, false);
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        if (this.drawBorders) {
            Insets contentBorderInsets = new Insets(4, 4, 4, 4);
            switch (tabPlacement) {
                case 1: {
                    contentBorderInsets.top = 1;
                    contentBorderInsets.bottom = 1;
                    break;
                }
                case 3: {
                    contentBorderInsets.bottom = 6;
                    break;
                }
                case 2: {
                    contentBorderInsets.left = 5;
                    contentBorderInsets.bottom = 6;
                    break;
                }
                case 4: {
                    contentBorderInsets.right = 5;
                    contentBorderInsets.bottom = 6;
                }
            }
            return contentBorderInsets;
        }
        return new Insets(1, 0, 0, 0);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabInsets = new Insets(2, 4, 1, 4);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement == 1 && selectedIndex >= 0 && selRect.y + selRect.height + 1 >= y && selRect.x >= x && selRect.x <= x + w) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(SHButtonUI.getBorderStroke());
            g2d.draw(new Line2D.Float(x, y, selRect.x - 1, y));
            if (selRect.x + selRect.width < x + w - 2) {
                g2d.draw(new Line2D.Float(selRect.x + selRect.width, y, x + w - 2, y));
            } else {
                g.setColor(this.shadow);
                g.setColor(Color.green);
                g2d.draw(new Line2D.Float(x + w - 2, y, x + w - 2, y));
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement == 2 && selectedIndex >= 0 && selRect.x + selRect.width + 1 >= x && selRect.y >= y && selRect.y <= y + h) {
            g.drawLine(x, y, x, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(Color.YELLOW);
        if (tabPlacement == 3 && selectedIndex >= 0 && selRect.y - 1 <= h && selRect.x >= x && selRect.x <= x + w) {
            g.drawLine(x + 1, y + h - 2, selRect.x - 1, y + h - 2);
            g.setColor(Color.YELLOW.darker());
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(Color.ORANGE);
                g.drawLine(selRect.x + selRect.width, y + h - 2, x + w - 2, y + h - 2);
                g.setColor(Color.YELLOW.darker());
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement == 4 && selectedIndex >= 0 && selRect.x - 1 <= w && selRect.y >= y && selRect.y <= y + h) {
            g.drawLine(x + w - 2, y + 1, x + w - 2, selRect.y - 1);
            g.setColor(Color.MAGENTA);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(Color.MAGENTA.darker());
                g.drawLine(x + w - 2, selRect.y + selRect.height, x + w - 2, y + h - 2);
                g.setColor(Color.MAGENTA);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paint(g, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setStroke(SHButtonUI.getBorderStroke());
        float stroke = SHButtonUI.getBorderStrokeWidth();
        g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, isSelected));
        RoundRectangle2D.Float clip = new RoundRectangle2D.Float(x, y, w, h, 2.0f, 2.0f);
        Shape oldClip = g2d.getClip();
        try {
            g2d.clip(clip);
            switch (tabPlacement) {
                case 2: {
                    RoundRectangle2D.Float s = new RoundRectangle2D.Float(x, y, w + 2, (float)h - stroke, 2.0f, 2.0f);
                    g2d.draw(s);
                    return;
                }
                case 4: {
                    g.drawLine(x, y, x + w - 3, y);
                    g.setColor(this.shadow);
                    g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                    g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                    g.setColor(this.darkShadow);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                    g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                    return;
                }
                case 3: {
                    g.drawLine(x, y, x, y + h - 3);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.setColor(this.shadow);
                    g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                    g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                    g.setColor(this.darkShadow);
                    g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                    return;
                }
                default: {
                    RoundRectangle2D.Float s = new RoundRectangle2D.Float(x, y, (float)w - stroke, h + 2, 2.0f, 2.0f);
                    g2d.draw(s);
                    return;
                }
            }
        }
        finally {
            g2d.setClip(oldClip);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        float width = SHButtonUI.getBorderStrokeWidth();
        if (isSelected) {
            g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, true, h, false));
        } else {
            g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, false, h, false));
        }
        switch (tabPlacement) {
            case 2: {
                g2d.fill(new RoundRectangle2D.Float(x, y, (float)w - width, (float)h - width, 2.0f, 2.0f));
                break;
            }
            case 4: {
                g2d.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g2d.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g2d.fill(new RoundRectangle2D.Float(x, y, (float)w - width, (float)h - width, 2.0f, 2.0f));
            }
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
    }
}

