/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import sun.swing.SwingUtilities2;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;

public class SHInternalFrameUI
extends BasicInternalFrameUI {
    private static final Border shadedBorder = new CompoundBorder(new ShadowBorder(), SHBorderFactory.createMatteBorder(0, 1, 1, 1, SHStyle.BORDER_COLOR)){

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    };
    private JComponent oldNorthPane = null;

    public SHInternalFrameUI(JInternalFrame frame) {
        super(frame);
        frame.setOpaque(false);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SHInternalFrameUI((JInternalFrame)c);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new SHInternalFrameTitlePane(w);
        return this.titlePane;
    }

    public void setDecorated(boolean showDecoration) {
        if (showDecoration && this.getNorthPane() != null) {
            return;
        }
        if (!showDecoration && this.getNorthPane() == null) {
            return;
        }
        if (showDecoration) {
            this.northPane = this.oldNorthPane;
        } else {
            this.oldNorthPane = this.northPane;
            this.northPane = null;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.frame.setBorder(shadedBorder);
    }

    private class SHInternalFrameTitlePane
    extends BasicInternalFrameTitlePane {
        public SHInternalFrameTitlePane(JInternalFrame f) {
            super(f);
            this.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        @Override
        protected void paintTitleBackground(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(243, 243, 243), 0.0f, this.getHeight(), new Color(212, 212, 212)));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void paintComponent(Graphics g) {
            this.paintTitleBackground(g);
            if (this.frame.getTitle() != null) {
                boolean isSelected = this.frame.isSelected();
                Font f = g.getFont();
                g.setFont(this.getFont());
                if (isSelected) {
                    g.setColor(this.selectedTextColor);
                } else {
                    g.setColor(this.notSelectedTextColor);
                }
                FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.frame, g);
                int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
                Rectangle r = new Rectangle(0, 0, 0, 0);
                if (this.frame.isIconifiable()) {
                    r = this.iconButton.getBounds();
                } else if (this.frame.isMaximizable()) {
                    r = this.maxButton.getBounds();
                } else if (this.frame.isClosable()) {
                    r = this.closeButton.getBounds();
                }
                String title = this.frame.getTitle();
                int titleX = this.getWidth() / 2 - fm.stringWidth(title) / 2;
                SwingUtilities2.drawString((JComponent)this.frame, g, title, titleX, baseline);
                g.setFont(f);
            }
        }
    }

    static class ShadowBorder
    implements Border {
        static final int SIZE = 5;

        ShadowBorder() {
        }

        public static double sigmoid(double x) {
            return 1.0 / (1.0 + Math.pow(Math.E, -1.0 * x));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            for (int i = 0; i <= 5; ++i) {
                int alphaVal = (int)(255.0 * (1.0 - ShadowBorder.sigmoid((double)i - 0.5)));
                int val = 150;
                Color cc = new Color(val, val, val, alphaVal);
                g.setColor(cc);
                int offset = 5 - i;
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.drawRoundRect(x + offset, y + offset, width - 2 * offset, height - 2 * offset, 7, 7);
            }
            g.drawRect(x, y, width - 1, height - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

