/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHUI;

public class SHComboBoxEditor
extends BasicComboBoxEditor {
    private static final ComboBoxBorder border = new ComboBoxBorder();

    public SHComboBoxEditor() {
        this.editor.setBorder(new ComboBoxBorder());
    }

    public static class UIResource
    extends SHComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }

    static class ComboBoxBorder
    extends AbstractBorder {
        ComboBoxBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 3, 0, 3);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(SHButtonUI.getBorderStroke());
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, c.isEnabled()));
            float stroke = ((BasicStroke)g2d.getStroke()).getLineWidth();
            Rectangle2D.Float rect = new Rectangle2D.Float(x, y, w + 2, (float)h - stroke);
            g2d.draw(rect);
        }
    }
}

