/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.validators;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.cui.validators.Validator;

public class CheckBoxValidator
extends Validator {
    private boolean desiredValue;

    public CheckBoxValidator(boolean desiredValue) {
        this.desiredValue = desiredValue;
    }

    @Override
    public String getValidatorID() {
        return "checkbox";
    }

    @Override
    public String toXML() {
        return "<Validator type=\"" + this.getValidatorID() + "\">" + Boolean.toString(this.desiredValue) + "</Validator>";
    }

    @Override
    public boolean isValid(JComponent component) {
        if (!(component instanceof JCheckBox) && !(component instanceof CheckBoxField.ConfigurableCheckBox)) {
            System.out.println("[CheckBoxValidator] Unknown component type: " + component.getClass().getName());
            return false;
        }
        if (component instanceof JCheckBox) {
            return ((JCheckBox)component).isSelected() == this.desiredValue;
        }
        return ((CheckBoxField.ConfigurableCheckBox)component).getCheckBox().isSelected() == this.desiredValue;
    }
}

