/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import utils.swing.SwingStyleInterface;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.ui.WidthSlider;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public abstract class ConfigUI {
    protected GbPanel rootComponent = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    protected ResourceBundle bundle;
    protected WidthSlider sliderUI;
    protected JLabel sliderLabel;
    private SwingStyleInterface style;
    private AbstractField.ChangeListener listener;
    protected ActionChangeListener actionChangeListener = new ActionChangeListener();
    protected KeyChangeListener keyChangeListener = new KeyChangeListener();

    public ConfigUI(ResourceBundle bundle, SwingStyleInterface style, AbstractField.ChangeListener listener) {
        this.listener = listener;
        this.bundle = bundle;
        this.style = style;
        this.initUI();
    }

    protected void notifyOfChange() {
        if (this.listener != null) {
            this.listener.changed(null);
        }
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public abstract void initUI();

    public abstract void saveConfigurationTo(CUIField var1);

    public abstract void loadConfigurationFrom(CUIField var1);

    class ActionChangeListener
    implements ActionListener {
        ActionChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ConfigUI.this.listener != null) {
                ConfigUI.this.listener.changed(null);
            }
        }
    }

    class KeyChangeListener
    extends KeyAdapter {
        KeyChangeListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (ConfigUI.this.listener != null) {
                ConfigUI.this.listener.changed(null);
            }
        }
    }
}

