/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.awt.Color;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.validators.RadioButtonsValidator;
import utils.swing.layout.GbPanel;
import utils.xml.XML14Util;

public class RadioButtonField
extends AbstractField {
    public static final String RADIOBUTTON_TYPE = "radiobutton";
    private GbPanel rootComponent = new GbPanel();
    private String[] options;
    private JRadioButton[] buttons;
    private int[] validIndices = null;
    private int defaultIndex = -1;

    public String[] getChoices() {
        return this.options;
    }

    public int[] getValidIndicesArray() {
        return this.validIndices;
    }

    @Override
    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        this.rootComponent.setBackground(backgroundColor);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setBackground(backgroundColor);
        }
    }

    @Override
    public void toXML(StringBuffer buffer, int tabs) {
        for (int i = 0; i < this.options.length; ++i) {
            boolean valid = RadioButtonField.isValidIndex(this.validIndices, i);
            buffer.append(XML14Util.getIndent(tabs));
            buffer.append("<Option valid=\"" + Boolean.toString(valid) + "\">" + this.options[i] + "</Option>\n");
        }
    }

    @Override
    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return new ResultPair(this.label, this.buttons[i].getText());
        }
        return null;
    }

    @Override
    public void setStorableFilledOutData(ResultPair data) {
        this.buttons[Integer.parseInt(data.getValue())].setSelected(true);
    }

    @Override
    public ResultPair getStorableFilledOutData() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return new ResultPair(this.label, Integer.toString(i));
        }
        return null;
    }

    public static RadioButtonField fromXML(Element element, AbstractField.ChangeListener cl) {
        String label = element.getAttribute("label");
        NodeList elementsByTagName = element.getElementsByTagName("Option");
        String[] options = new String[elementsByTagName.getLength()];
        ArrayList<Integer> listOfValidIntegers = new ArrayList<Integer>();
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element choiceElement = (Element)elementsByTagName.item(i);
            options[i] = XML14Util.getTextContent(choiceElement);
            if (!Boolean.parseBoolean(choiceElement.getAttribute("valid"))) continue;
            listOfValidIntegers.add(new Integer(i));
        }
        int[] validIndices = new int[listOfValidIntegers.size()];
        for (int i = 0; i < listOfValidIntegers.size(); ++i) {
            validIndices[i] = (Integer)listOfValidIntegers.get(i);
        }
        RadioButtonField type = new RadioButtonField(label, cl, options);
        type.setValidOptions(validIndices);
        return type;
    }

    public RadioButtonField(String label, AbstractField.ChangeListener changeListener) {
        this(label, changeListener, new String[0]);
    }

    public RadioButtonField(String label, AbstractField.ChangeListener changeListener, String[] options) {
        super(RADIOBUTTON_TYPE, label, changeListener);
        this.options = options;
        this.initUI();
    }

    public void setOptions(String[] options) {
        this.options = options;
        this.rootComponent.removeAll();
        this.initUI();
    }

    public void setValidOptions(int[] validIndices) {
        this.validIndices = validIndices;
        this.addValidator(new RadioButtonsValidator(validIndices));
    }

    public void setDefaultIndex(int index) {
        this.defaultIndex = index;
        this.buttons[index].setSelected(true);
    }

    private void initUI() {
        ButtonGroup group = new ButtonGroup();
        this.buttons = new JRadioButton[this.options.length];
        for (int i = 0; i < this.options.length; ++i) {
            JRadioButton button = new JRadioButton(this.options[i]);
            button.putClientProperty("INDEX", new Integer(i));
            button.addActionListener(this.proxyChangeListener);
            this.buttons[i] = button;
            this.rootComponent.add(button, 0, i, 1, 1, 1, 1, 10, 2);
            group.add(button);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.rootComponent;
    }

    @Override
    public void clearContents() {
        if (this.defaultIndex == -1) {
            this.buttons[0].setSelected(true);
        } else {
            this.buttons[this.defaultIndex].setSelected(true);
        }
    }
}

