/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.swing.browser.Browser;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.validators.CheckBoxValidator;
import utils.swing.layout.GbPanel;
import utils.xml.XML14Util;

public class CheckBoxField
extends AbstractField {
    public static final String CHECKBOX_TYPE = "checkbox";
    private ConfigurableCheckBox compoundComponent;
    private URL targetURL;
    private Boolean validOption;
    private Boolean defaultCheckedState = null;

    public void setURL(String url) {
        if (url != null && url.length() > 0) {
            try {
                this.targetURL = new URL(url);
            }
            catch (MalformedURLException ex) {
                try {
                    this.targetURL = new URL("http://" + url);
                }
                catch (MalformedURLException ex2) {
                    ex2.printStackTrace();
                    this.targetURL = null;
                }
            }
        }
    }

    public CheckBoxField(String label, AbstractField.ChangeListener changeListener) {
        this(label, changeListener, null);
    }

    public CheckBoxField(String label, AbstractField.ChangeListener changeListener, String url) {
        super(CHECKBOX_TYPE, label, changeListener);
        this.initUI(label, url);
    }

    public void setDefaultCheckedState(boolean isChecked) {
        this.defaultCheckedState = new Boolean(isChecked);
        this.compoundComponent.setChecked(isChecked);
    }

    @Override
    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        this.compoundComponent.checkBox.setBackground(backgroundColor);
        this.compoundComponent.jLabel.setBackground(backgroundColor);
        this.compoundComponent.setBackground(backgroundColor);
    }

    @Override
    public boolean renderLabel() {
        return false;
    }

    @Override
    public void toXML(StringBuffer buffer, int tabs) {
        if (this.targetURL != null) {
            buffer.append(XML14Util.getIndent(tabs)).append("<URL>" + this.targetURL.toString() + "</URL>\n");
        }
        if (this.validOption != null) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Valid>" + this.validOption + "</Valid>\n");
        }
        if (this.defaultCheckedState != null) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Default>" + this.validOption + "</Default>\n");
        }
    }

    @Override
    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        if (this.compoundComponent.checkBox.isSelected()) {
            return new ResultPair(this.label, bundle.getString("YES"));
        }
        return new ResultPair(this.label, bundle.getString("NO"));
    }

    @Override
    public ResultPair getStorableFilledOutData() {
        return new ResultPair(this.label, Boolean.toString(this.compoundComponent.checkBox.isSelected()));
    }

    @Override
    public void setStorableFilledOutData(ResultPair data) {
        this.compoundComponent.checkBox.setSelected(Boolean.parseBoolean(data.getValue()));
    }

    public static CheckBoxField fromXML(Element element, AbstractField.ChangeListener cl) {
        String label = element.getAttribute("label");
        NodeList urlElement = element.getElementsByTagName("URL");
        String url = urlElement.getLength() > 0 ? XML14Util.getTextContent(urlElement.item(0)) : null;
        String valid = XML14Util.getChildText(element, "Valid", null);
        Boolean validOption = null;
        if (valid != null) {
            validOption = new Boolean(Boolean.parseBoolean(valid));
        }
        String defaultChecked = XML14Util.getChildText(element, "Default", null);
        Boolean defaultCheckedBoolean = null;
        if (defaultChecked != null) {
            defaultCheckedBoolean = new Boolean(Boolean.parseBoolean(defaultChecked));
        }
        CheckBoxField cField = new CheckBoxField(label, cl, url);
        cField.setValidOption(validOption);
        if (defaultCheckedBoolean != null) {
            cField.setDefaultCheckedState(defaultCheckedBoolean);
        }
        return cField;
    }

    private void initUI(String label, String url) {
        this.setURL(url);
        this.compoundComponent = new ConfigurableCheckBox(label, url);
    }

    @Override
    public JComponent getComponent() {
        return this.compoundComponent;
    }

    public void setValidOption(Boolean validOption) {
        this.validOption = validOption;
        if (validOption != null) {
            this.addValidator(new CheckBoxValidator(validOption));
        }
    }

    public Boolean getValidOption() {
        return this.validOption;
    }

    @Override
    public void clearContents() {
        this.compoundComponent.getCheckBox().setSelected(false);
    }

    public boolean isChecked() {
        return this.compoundComponent.getCheckBox().isSelected();
    }

    class HyperLinkMouseListener
    extends MouseAdapter {
        HyperLinkMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (CheckBoxField.this.targetURL != null) {
                try {
                    Browser.openURL(CheckBoxField.this.targetURL);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else {
                CheckBoxField.this.compoundComponent.checkBox.setSelected(!CheckBoxField.this.compoundComponent.checkBox.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckBoxField.this.compoundComponent.checkBox.repaint();
                    }
                });
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (CheckBoxField.this.targetURL != null) {
                JComponent source = (JComponent)e.getSource();
                source.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (CheckBoxField.this.targetURL != null) {
                JComponent source = (JComponent)e.getSource();
                source.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public class ConfigurableCheckBox
    extends GbPanel {
        private JLabel jLabel;
        private JCheckBox checkBox = new JCheckBox();

        public ConfigurableCheckBox(String label, String url) {
            this.checkBox.addChangeListener(CheckBoxField.this.proxyChangeListener);
            this.jLabel = CheckBoxField.this.targetURL == null ? new JLabel(label) : new JLabel("<html><font color=#5571A9><a href=\"" + url + "\">" + label + "</a></html>");
            this.jLabel.addMouseListener(new HyperLinkMouseListener());
            this.add(this.checkBox, 0, 0, 1, 1, 0, 1, 10, 0);
            this.add(this.jLabel, 1, 0, 1, 1, 10000, 1, 10, 2);
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public void setChecked(boolean isChecked) {
            this.checkBox.setSelected(isChecked);
        }
    }
}

