/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.layouts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.border.MatteBorder;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.IsValidListener;
import utils.swing.layout.GbPanel;

public class CUIHorizontalPanel {
    private GbPanel rootComponent;
    private Group openGroup = null;
    private int Y = 0;
    private ArrayList<CUIField> allFields = new ArrayList();
    private Color backgroundColor;
    private IsValidListener validListener;

    public CUIHorizontalPanel(Insets insets, boolean alignLeftColumns) {
        this.rootComponent = alignLeftColumns ? new FixedSizeGbPanel(insets) : new GbPanel(insets);
    }

    protected CUIHorizontalPanel(Insets insets, boolean alignLeftColumns, CUIHorizontalPanel parent, int buffer) {
        this.rootComponent = alignLeftColumns ? new FixedSizeGbPanel(insets, (FixedSizeGbPanel)parent.rootComponent, buffer) : new GbPanel(insets);
    }

    public void setValidListener(IsValidListener listener) {
        this.validListener = listener;
    }

    public ResultPair[] getFilledOutResults(ResourceBundle bundle) {
        int sizeOfResults = 0;
        for (CUIField allField : this.allFields) {
            if (!(allField instanceof AbstractField)) continue;
            ++sizeOfResults;
        }
        ResultPair[] pairs = new ResultPair[sizeOfResults];
        int currentCount = 0;
        for (CUIField field : this.allFields) {
            if (!(field instanceof AbstractField)) continue;
            pairs[currentCount++] = field.getReadableFilledOutData(bundle);
        }
        return pairs;
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public void addAll(CUIField[] types) {
        for (CUIField type : types) {
            this.add(type);
        }
    }

    public void add(CUIField type) {
        this.allFields.add(type);
        if (this.openGroup != null) {
            this.openGroup.addType(type);
        } else {
            type.populate(this.rootComponent, 0, this.Y++);
        }
    }

    public boolean isValid() {
        if (this.validListener != null && !this.validListener.isValid()) {
            return false;
        }
        return this.getInvalidFieldTypes().size() == 0;
    }

    public ArrayList<AbstractField> getInvalidFieldTypes() {
        ArrayList<AbstractField> invalidTypes = new ArrayList<AbstractField>();
        for (CUIField allField : this.allFields) {
            AbstractField field;
            if (!(allField instanceof AbstractField) || (field = (AbstractField)allField).isValid()) continue;
            invalidTypes.add(field);
        }
        return invalidTypes;
    }

    public void openGroup(String title) {
        this.openGroup = new Group(title);
    }

    public void closeGroup() {
        this.openGroup.populate(this.rootComponent, 0, this.Y++);
        this.openGroup = null;
    }

    public void setChangeListener(AbstractField.ChangeListener changeListener) {
        for (CUIField field : this.allFields) {
            if (!(field instanceof AbstractField)) continue;
            AbstractField aField = (AbstractField)field;
            aField.setChangeListener(changeListener);
        }
    }

    public void setBackground(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.getRootComponent().setBackground(backgroundColor);
        for (CUIField field : this.allFields) {
            if (!(field instanceof AbstractField)) continue;
            AbstractField aField = (AbstractField)field;
            aField.setBackground(backgroundColor);
        }
    }

    public ArrayList<CUIField> getAllFields() {
        return this.allFields;
    }

    class FixedSizeGbPanel
    extends GbPanel {
        private int minWidth;
        private ArrayList<Component> leftComponents;
        private FixedSizeGbPanel dependent;
        private int buffer;

        public FixedSizeGbPanel(Insets insets) {
            super(insets);
            this.minWidth = 0;
            this.leftComponents = new ArrayList();
            this.buffer = 0;
        }

        public FixedSizeGbPanel(Insets insets, FixedSizeGbPanel dependent, int buffer) {
            super(insets);
            this.minWidth = 0;
            this.leftComponents = new ArrayList();
            this.buffer = 0;
            this.buffer = buffer;
            this.dependent = dependent;
            this.minWidth = dependent.minWidth;
        }

        @Override
        public void add(Component c, int x, int y, int w, int h, int weightx, int weighty, int align, int spread) {
            super.add(c, x, y, w, h, weightx, weighty, align, spread);
            if (x == 0 && w == 1) {
                this.fixSize(c);
            }
        }

        @Override
        public void add(Component c, int x, int y, int w, int h, int weightx, int weighty, int align, int spread, Insets is) {
            super.add(c, x, y, w, h, weightx, weighty, align, spread, is);
            if (x == 0 && w == 1) {
                this.fixSize(c);
            }
        }

        private void fixSize(Component c) {
            this.leftComponents.add(c);
            if (this.minWidth == 0) {
                this.minWidth = c.getPreferredSize().width;
            } else {
                this.minWidth = Math.max(this.minWidth, c.getPreferredSize().width);
                this.setMinWidth(this.minWidth);
                if (this.dependent != null) {
                    this.dependent.setMinWidth(this.minWidth + this.buffer);
                }
            }
            Dimension dim = c.getPreferredSize();
            dim.width = this.minWidth;
            c.setMinimumSize(dim);
            c.setPreferredSize(dim);
        }

        private void setMinWidth(int minWidth) {
            this.minWidth = minWidth;
            for (Component leftComponent : this.leftComponents) {
                leftComponent.getPreferredSize().width = minWidth;
            }
        }
    }

    class Group
    implements CUIField {
        private String title;
        private CUIHorizontalPanel subPanel;
        private int groupBorderSize = 10;

        public Group() {
            this(null);
        }

        public Group(String title) {
            this.title = title;
            this.subPanel = CUIHorizontalPanel.this.rootComponent instanceof FixedSizeGbPanel ? new CUIHorizontalPanel(CUIHorizontalPanel.this.rootComponent.getGbPanelInsets(), true, CUIHorizontalPanel.this, SimpleHelpLookAndFeel.scale(10)) : new CUIHorizontalPanel(CUIHorizontalPanel.this.rootComponent.getGbPanelInsets(), false);
        }

        public void addType(CUIField type) {
            this.subPanel.add(type);
        }

        @Override
        public void populate(GbPanel panel, int X, int Y) {
            MatteBorder border = SHBorderFactory.createMatteBorder(this.groupBorderSize, this.groupBorderSize, this.groupBorderSize, this.groupBorderSize, Color.green);
            this.subPanel.getRootComponent().setBorder(border);
            panel.add(this.subPanel.getRootComponent(), X, Y, 2, 1, 0, 0, 17, 2, new Insets(0, 0, 0, 0));
        }

        @Override
        public String toXML(int tabs) {
            return "";
        }

        @Override
        public String getLabel() {
            return null;
        }

        @Override
        public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
            return null;
        }

        @Override
        public void clearContents() {
        }

        public Insets getLayoutInsets() {
            return null;
        }

        @Override
        public void setLayoutInsets(Insets layoutInsets) {
        }

        @Override
        public ResultPair getStorableFilledOutData() {
            return null;
        }

        @Override
        public void setStorableFilledOutData(ResultPair storableFilledOutData) {
        }

        @Override
        public void setDisplayLabel(String displayLabel) {
        }

        @Override
        public String getDisplayLabel() {
            return null;
        }
    }
}

