/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.reorderablepanel;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Collections;
import javax.swing.JPanel;
import utils.swing.components.reorderablepanel.ReorderablePanel;
import utils.swing.components.reorderablepanel.ReorderablePanelList;

public class ReorderablePanelDropTargetListener
implements DropTargetListener {
    private final ReorderablePanelList rootPanel;
    private ReorderNotifier notifier = null;
    private static final Cursor droppableCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor notDroppableCursor = Cursor.getPredefinedCursor(1);

    public ReorderablePanelDropTargetListener(ReorderablePanelList sheet) {
        this.rootPanel = sheet;
    }

    public void setReorderNotifier(ReorderNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.getDropTargetContext();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        ReorderablePanel droppedPanel;
        if (!this.rootPanel.getCursor().equals(droppableCursor)) {
            this.rootPanel.setCursor(droppableCursor);
        }
        if ((droppedPanel = this.getDragDropPanel(null, dtde)) == null) {
            System.out.println("droppedPanel == null!");
            return;
        }
        DropTarget target = (DropTarget)dtde.getSource();
        int y = this.getYRelativeToRootPanel(target, (int)dtde.getLocation().getY());
        this.reorder(y, droppedPanel);
    }

    private int getYRelativeToRootPanel(DropTarget target, int dtdeY) {
        int y;
        if (target.getComponent() == this.rootPanel) {
            y = dtdeY;
        } else {
            JPanel source = (JPanel)target.getComponent();
            Rectangle rect = source.getBounds();
            y = dtdeY + rect.y;
        }
        return y;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.rootPanel.setCursor(notDroppableCursor);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.rootPanel.setCursor(Cursor.getDefaultCursor());
        ReorderablePanel droppedPanel = this.getDragDropPanel(dtde, null);
        if (droppedPanel == null) {
            return;
        }
        DropTarget target = (DropTarget)dtde.getSource();
        int y = this.getYRelativeToRootPanel(target, (int)dtde.getLocation().getY());
        this.reorder(y, droppedPanel);
    }

    private ReorderablePanel getDragDropPanel(DropTargetDropEvent dtde, DropTargetDragEvent dtde2) {
        DataFlavor dragAndDropPanelFlavor = null;
        Object transferableObj = null;
        Transferable transferable = null;
        try {
            dragAndDropPanelFlavor = ReorderablePanelList.getDragAndDropPanelDataFlavor();
            transferable = dtde != null ? dtde.getTransferable() : dtde2.getTransferable();
            if (transferable.isDataFlavorSupported(dragAndDropPanelFlavor)) {
                transferableObj = transferable.getTransferData(dragAndDropPanelFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (transferableObj == null) {
            return null;
        }
        return (ReorderablePanel)transferableObj;
    }

    private void reorder(int dropYLoc, ReorderablePanel droppedPanel) {
        droppedPanel.setOverrideY(dropYLoc);
        Collections.sort(this.rootPanel.getReorderablePanels());
        this.rootPanel.relayout();
        if (this.notifier != null) {
            this.notifier.reorderHappened();
        }
    }

    public static interface ReorderNotifier {
        public void reorderHappened();
    }
}

