/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.messagefields;

import java.awt.event.FocusEvent;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import utils.ostools.OS;
import utils.swing.components.messagefields.MessageComponent;
import utils.swing.components.messagefields.MessageFieldHandler;

public class MessagePasswordTextField
extends JPasswordField
implements MessageComponent {
    private MessageFieldHandler handler;
    private char echoChar;

    public MessagePasswordTextField(String message, MessageFieldHandler.FilterListener filterListener) {
        this.handler = new MessageFieldHandler(this, message, filterListener){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                MessagePasswordTextField.this.setEchoChar(MessagePasswordTextField.this.echoChar);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (MessagePasswordTextField.this.getPassword().length == 0) {
                    ((JPasswordField)this.delegate).setEchoChar('\u0000');
                }
            }

            @Override
            public void setDefaultColor() {
                super.setDefaultColor();
                MessagePasswordTextField.this.setEchoChar(MessagePasswordTextField.this.echoChar);
            }
        };
        this.handler.init();
        this.echoChar = this.getEchoChar();
        this.setFont(UIManager.getDefaults().getFont("TextField.font"));
        this.setBackground(UIManager.getDefaults().getColor("TextField.background"));
        this.setEchoChar('\u0000');
        if (OS.isMacOS()) {
            this.echoChar = (char)8226;
        }
    }

    @Override
    public void setMessageText(String message) {
        this.handler.setMessageText(message);
        if (this.handler.isShowingMessage()) {
            this.setEchoChar('\u0000');
        } else {
            this.setEchoChar(this.echoChar);
        }
    }

    @Override
    public char[] getPassword() {
        if (this.handler.hasEnteredText()) {
            return super.getPassword();
        }
        return new char[0];
    }

    @Override
    public void setText(String text) {
        if (text == null || text.length() == 0) {
            if (!this.hasFocus()) {
                this.handler.clear();
            } else {
                super.setText("");
            }
        } else {
            super.setText(text);
            this.handler.setDefaultColor();
        }
        this.repaint();
    }

    @Override
    public void clear() {
        this.handler.clear();
        if (!this.hasFocus()) {
            super.setText(this.handler.getSearchText());
            this.handler.setGrayColor();
        } else {
            super.setText("");
        }
    }

    @Override
    public boolean hasEnteredText() {
        return this.handler.hasEnteredText();
    }

    public void imitateHasFocus() {
        this.handler.focusGained(null);
        super.setText("");
    }
}

