/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.slider;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ChoiceItem {
    Icon icon;
    String name;
    String description;
    JComponent contentPanel;
    ChoiceItem parent;
    ChoiceItem[] children;
    boolean preSelected = false;
    String example;

    public ChoiceItem(String name, String description, String example, Icon icon, JComponent contentPanel) {
        this.name = name;
        this.description = description;
        this.example = example;
        this.icon = icon;
        this.contentPanel = contentPanel;
    }

    public ChoiceItem(String name, String description, String example, Icon icon, ArrayList<ChoiceItem> children) {
        this(name, description, example, icon, children.toArray(new ChoiceItem[0]));
    }

    public ChoiceItem(String name, String description, String example, Icon icon, ChoiceItem[] children) {
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.children = children;
        this.example = example;
        for (ChoiceItem item : children) {
            item.parent = this;
        }
    }

    private void getPathToRoot(LinkedList<ChoiceItem> path) {
        path.addFirst(this);
        if (this.parent == null) {
            return;
        }
        this.parent.getPathToRoot(path);
    }

    public ChoiceItem[] getPathToRoot() {
        LinkedList<ChoiceItem> path = new LinkedList<ChoiceItem>();
        this.getPathToRoot(path);
        return path.toArray(new ChoiceItem[0]);
    }

    public void setPreSelected(boolean pre) {
        this.preSelected = pre;
    }

    public void setParent(ChoiceItem item) {
        this.parent = item;
    }

    public boolean hasSubChoices() {
        return this.children != null;
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }
}

