/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.arrow;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import utils.ostools.OS;

public class ArrowDrawer {
    public static final long DEFAULT_PERIOD = 2000L;
    private static final float PI = (float)Math.PI;
    private static final int[] x = new int[]{8, 8, 11};
    private static final int[] y = new int[]{0, 6, 3};
    private static final BasicStroke stroke = new BasicStroke(1.0f, 0, 2);
    private static final BasicStroke strokeThicker = new BasicStroke(1.5f, 0, 2);
    private AffineTransform transform = new AffineTransform();
    private Arc2D arc = new Arc2D.Float(3.0f, 3.0f, 10.0f, 10.0f, 65.0f, 140.0f, 0);
    private Arc2D arcRetina = new Arc2D.Float(6.0f, 6.0f, 20.0f, 20.0f, 65.0f, 140.0f, 0);
    private GeneralPath path = new GeneralPath();
    private boolean drawHeads;
    private Color foreground;

    public ArrowDrawer(boolean drawHeads) {
        this.drawHeads = drawHeads;
        this.foreground = drawHeads ? Color.DARK_GRAY : new Color(78, 116, 160);
    }

    public ArrowDrawer(boolean drawHeads, Color foreground) {
        this(drawHeads);
        this.foreground = foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintForeground(Graphics2D g, int xx, int yy, int w, int h) {
        AffineTransform oldTransform = g.getTransform();
        int factor = 1;
        if (OS.isOSXRetina()) {
            factor = 2;
            g.scale(0.5, 0.5);
            xx *= 2;
            yy *= 2;
        }
        try {
            g.setColor(this.foreground);
            int xOffset = xx;
            int yOffset = yy;
            g.translate(xOffset, yOffset);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            long period = 2000L;
            if (this.drawHeads) {
                g.setStroke(stroke);
            } else {
                g.setStroke(strokeThicker);
            }
            float t = System.currentTimeMillis() % period;
            float f = t / (float)period * 2.0f * (float)Math.PI;
            for (int k = 0; k < 2; ++k) {
                this.transform.setToRotation((double)f + (double)k * Math.PI, w * factor / 2, h * factor / 2);
                if (this.drawHeads) {
                    this.path.reset();
                    this.path.moveTo(x[0] * factor, y[0] * factor);
                    this.path.lineTo(x[1] * factor, y[1] * factor);
                    this.path.lineTo(x[2] * factor, y[2] * factor);
                    this.path.lineTo(x[0] * factor, y[0] * factor);
                    this.path.transform(this.transform);
                    g.fill(this.path);
                    this.path.reset();
                    if (OS.isOSXRetina()) {
                        this.path.append(this.arcRetina.getPathIterator(this.transform), false);
                    } else {
                        this.path.append(this.arc.getPathIterator(this.transform), false);
                    }
                    g.draw(this.path);
                    continue;
                }
                this.path.reset();
                if (OS.isOSXRetina()) {
                    this.path.append(this.arcRetina.getPathIterator(this.transform), false);
                } else {
                    this.path.append(this.arc.getPathIterator(this.transform), false);
                }
                g.draw(this.path);
            }
            g.translate(-xOffset, -yOffset);
        }
        finally {
            g.setTransform(oldTransform);
        }
    }
}

