/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import utils.swing.customlaf.SHStyle;

public class SimpleMessagePanel
extends JPanel {
    private String message;
    private Color bgColor;
    private Color textColor;

    public SimpleMessagePanel(String message, Color textColor, Color bgColor) {
        this.message = message;
        this.textColor = textColor;
        this.bgColor = bgColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getComponentCount() == 0) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Insets insets = this.getInsets();
            g.setFont(SHStyle.largeFont);
            g.setColor(this.bgColor);
            g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            g.setColor(this.textColor);
            TextLayout tl = new TextLayout(this.message, g.getFont(), g2d.getFontRenderContext());
            Rectangle2D r = tl.getBounds();
            tl.draw(g2d, (float)((double)(this.getWidth() / 2) - r.getWidth() / 2.0), (float)(this.getHeight() / 2) + tl.getDescent());
        } else {
            super.paintComponent(g);
        }
    }
}

