/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHJTree
extends JTree {
    private final Color selectedColor;

    public SHJTree(Color selectedColor) {
        this.setUI(new SHTreeUI());
        this.selectedColor = selectedColor;
        this.setLargeModel(true);
        this.setRowHeight(SimpleHelpLookAndFeel.scale(26));
    }

    public SHJTree(TreeModel treeModel, Color selectedColor) {
        super(treeModel);
        this.setUI(new SHTreeUI());
        this.selectedColor = selectedColor;
        this.setLargeModel(true);
        this.setRowHeight(SimpleHelpLookAndFeel.scale(26));
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int fromRow = this.getRowForPath(this.getSelectionPath());
        if (fromRow != -1) {
            int toRow = fromRow + 1;
            Rectangle fromBounds = this.getRowBounds(fromRow);
            Rectangle toBounds = this.getRowBounds(toRow - 1);
            if (fromBounds != null && toBounds != null) {
                g.setColor(this.selectedColor);
                g.fillRect(0, fromBounds.y, this.getWidth(), toBounds.y - fromBounds.y + toBounds.height);
            }
        }
        this.setOpaque(false);
        super.paintComponent(g);
        this.setOpaque(true);
    }

    class SHTreeUI
    extends BasicTreeUI {
        private BasicTreeUI.NodeDimensionsHandler handler;

        SHTreeUI() {
        }

        @Override
        protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        @Override
        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            this.handler = new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    Insets insets = SHTreeUI.this.tree.getInsets();
                    dimensions.width = SHTreeUI.this.tree.getWidth() - this.getRowX(row, depth) - insets.left - insets.right;
                    return dimensions;
                }
            };
            return this.handler;
        }
    }
}

