/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.layout.GbPanel;

public class RadialProgressBar
extends JPanel {
    double percentage = 0.0;
    private int gap = 0;
    private Color color = Color.GRAY;
    private boolean drawRing = true;

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.color = c;
    }

    public void setGapBetweenFillAndRing(int buffer) {
        this.gap = buffer;
    }

    public void setPercentageComplete(double done) {
        this.percentage = Math.min(1.0, Math.max(0.0, done));
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Paint oldPaint = g2d.getPaint();
        try {
            int degreesToPaint = -((int)(this.percentage * 360.0));
            int width = this.getWidth();
            int height = this.getHeight();
            g2d.setColor(this.color);
            int buffer = 2;
            int x = insets.left + this.gap + buffer;
            int y = insets.top + this.gap + buffer;
            int circleWidth = width - 2 * buffer - insets.left - insets.right - 2 * this.gap;
            int circleHeight = height - 2 * buffer - insets.top - insets.bottom - 2 * this.gap;
            g2d.fillArc(x, y, circleWidth, circleHeight, 90, degreesToPaint);
            if (this.drawRing) {
                x = insets.left + buffer;
                y = insets.top + buffer;
                circleWidth = width - 2 * buffer - insets.left - insets.right;
                circleHeight = height - 2 * buffer - insets.top - insets.bottom;
                BasicStroke stroke = new BasicStroke(0.75f);
                g2d.setStroke(stroke);
                g2d.drawArc(x, y, circleWidth, circleHeight, 0, 360);
            }
        }
        finally {
            g2d.setPaint(oldPaint);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        RadialProgressBar bar = new RadialProgressBar();
        bar.setGapBetweenFillAndRing(0);
        bar.drawRing(true);
        GbPanel panel = new GbPanel();
        panel.add(bar, 0, 0, 1, 1, 1, 1, 10, 0);
        SwingUtil.setSize(bar, 20, 20);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        for (int i = 0; i <= 100; ++i) {
            double done = i;
            bar.setPercentageComplete(done /= 100.0);
            Thread.sleep(10L);
        }
    }

    private void drawRing(boolean drawRing) {
        this.drawRing = drawRing;
    }
}

