/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import utils.swing.customlaf.SHBorderFactory;

public class JWrapTextPaneLabel
extends JTextPane {
    public JWrapTextPaneLabel(String s) {
        this(false);
        this.setText(s);
    }

    public JWrapTextPaneLabel() {
        this(false);
    }

    public JWrapTextPaneLabel(boolean allowTextCopy) {
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(1);
        this.setOpaque(false);
        this.setBorder(SHBorderFactory.createEmptyBorder());
        this.setFont(UIManager.getFont("Label.font"));
        this.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.setBackground(this.getBackground());
        this.setEditable(false);
        this.setEnabled(allowTextCopy);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superPreferred = super.getPreferredSize();
        return new Dimension((int)Math.min(1.0, superPreferred.getWidth()), (int)superPreferred.getHeight());
    }

    public void center() {
        StyledDocument doc = (StyledDocument)this.getDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.setDisabledTextColor(c);
    }
}

