/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;

public class JSmartPopupMenu
extends JPopupMenu {
    public JSmartPopupMenu() {
    }

    public JSmartPopupMenu(String string) {
        super(string);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        int smartX = x;
        int smartY = y;
        int offsetY = 0;
        if (invoker != null) {
            Rectangle screenBounds = invoker.getGraphicsConfiguration().getBounds();
            Dimension screenSize = screenBounds.getSize();
            double invokerX = invoker.getLocationOnScreen().getX();
            double invokerY = invoker.getLocationOnScreen().getY();
            double screenPopupX = invokerX + (double)x;
            double screenPopupY = invokerY + (double)y;
            double popupHeight = this.getPreferredSize().getHeight();
            double popupWidth = this.getPreferredSize().getWidth();
            if (screenPopupY + popupHeight > screenSize.getHeight() + (double)screenBounds.y) {
                smartY = (int)(screenSize.getHeight() - popupHeight - invokerY);
                smartY += screenBounds.y;
            }
            if (screenPopupX + popupWidth > screenSize.getWidth() + (double)screenBounds.x) {
                smartX = (int)(screenSize.getWidth() - popupWidth - invokerX);
                smartX += screenBounds.x;
            }
        }
        final Color startBackgroundColor = invoker.getBackground();
        final Color startForegroundColor = this.getAverage(startBackgroundColor, this.getForeground());
        final Color endBackgroundColor = this.getBackground();
        final Color endForegroundColor = this.getForeground();
        this.setBackground(startBackgroundColor);
        this.setForeground(startForegroundColor);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            c.setBackground(startBackgroundColor);
            c.setForeground(startForegroundColor);
        }
        super.show(invoker, smartX, smartY - offsetY);
        Thread transition = new Thread(){

            @Override
            public void run() {
                for (int transIndex = 4; transIndex < 10; ++transIndex) {
                    Color fg = JSmartPopupMenu.this.interpolateColor(0, 9, transIndex, startForegroundColor, endForegroundColor);
                    Color bg = JSmartPopupMenu.this.interpolateColor(0, 9, transIndex, startBackgroundColor, endBackgroundColor);
                    JSmartPopupMenu.this.setBackground(bg);
                    JSmartPopupMenu.this.setForeground(fg);
                    for (int i = 0; i < JSmartPopupMenu.this.getComponentCount(); ++i) {
                        Component c = JSmartPopupMenu.this.getComponent(i);
                        c.setBackground(bg);
                        c.setForeground(fg);
                    }
                    try {
                        Thread.sleep(60L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        transition.start();
    }

    private Color interpolateColor(int startIndex, int endIndex, int currentIndex, Color startColor, Color endColor) {
        double span = endIndex - startIndex;
        double r = (double)(startColor.getRed() * (endIndex - currentIndex) + endColor.getRed() * (currentIndex - startIndex)) / span;
        double g = (double)(startColor.getGreen() * (endIndex - currentIndex) + endColor.getGreen() * (currentIndex - startIndex)) / span;
        double b = (double)(startColor.getBlue() * (endIndex - currentIndex) + endColor.getBlue() * (currentIndex - startIndex)) / span;
        return new Color((int)r, (int)g, (int)b);
    }

    public Color getAverage(Color c1, Color c2) {
        int r = (c1.getRed() + c2.getRed()) / 2;
        int g = (c1.getGreen() + c2.getGreen()) / 2;
        int b = (c1.getBlue() + c2.getBlue()) / 2;
        return new Color(r, g, b);
    }
}

