/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.UIManager;
import utils.swing.components.JIconTextField;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class JSearchTextField
extends JIconTextField
implements FocusListener {
    private String textWhenNotFocused;
    private MessageFieldHandler.FilterListener filterListener = null;
    private String lastNotifiedFilter = null;
    public static final String CLEAR_ID = "CLEAR";

    public JSearchTextField(String messageText) {
        this.textWhenNotFocused = messageText;
        this.addFocusListener(this);
        this.addIconClickListener(new JIconTextField.IconClickListener(){

            @Override
            public void iconClicked(String id) {
                if (id.equals(JSearchTextField.CLEAR_ID)) {
                    JSearchTextField.this.setText("");
                    JSearchTextField.this.notifyFilterListener(null, true);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                JSearchTextField.this.notifyFilterListener(JSearchTextField.this.getText().trim(), event.getKeyCode() == 10);
            }
        });
    }

    private void notifyFilterListener(String filter, boolean immediately) {
        if (this.filterListener == null) {
            return;
        }
        if (immediately || this.lastNotifiedFilter == null && filter != null || filter == null && this.lastNotifiedFilter != null || !this.lastNotifiedFilter.equals(filter)) {
            this.lastNotifiedFilter = filter;
            this.filterListener.setFilter(filter, immediately);
        }
    }

    public void setFilterListener(MessageFieldHandler.FilterListener listener) {
        this.filterListener = listener;
    }

    public String getTextWhenNotFocused() {
        return this.textWhenNotFocused;
    }

    public void setTextWhenNotFocused(String newText) {
        this.textWhenNotFocused = newText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getText().equals("")) {
            int height = this.getHeight();
            Font prev = g.getFont();
            Color prevColor = g.getColor();
            g.setColor(UIManager.getColor("textInactiveText"));
            int h = g.getFontMetrics().getHeight();
            int textBottom = (height - h) / 2 + h - SimpleHelpLookAndFeel.scale(3);
            int x = this.getInsets().left;
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints hints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.textWhenNotFocused, x, textBottom);
            g2d.setRenderingHints(hints);
            g.setFont(prev);
            g.setColor(prevColor);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }
}

