/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import utils.ostools.OS;
import utils.swing.DimensionUtil;
import utils.swing.SwingUtil;

public class FitImagePanel
extends JPanel {
    private Color bgColor;
    protected Image image;

    public void setUnscaledBorderColor(Color bg) {
        this.bgColor = bg;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        Dimension dim = new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bgColor != null) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g;
        SwingUtil.setRenderingHints(g2d);
        int factor = 1;
        if (OS.isOSXRetina()) {
            factor = 2;
        }
        AffineTransform transform = SwingUtil.prepareForRetina(g2d);
        try {
            if (this.image != null) {
                Dimension bound = new Dimension(this.getWidth() * factor, this.getHeight() * factor);
                Dimension imageSize = new Dimension(this.image.getWidth(null), this.image.getHeight(null));
                Dimension scaledImageSize = DimensionUtil.getScaledDimension(imageSize, bound, true);
                int x = (this.getWidth() * factor - scaledImageSize.width) / 2;
                int y = (this.getHeight() * factor - scaledImageSize.height) / 2;
                g2d.drawImage(this.image, x, y, x + scaledImageSize.width, y + scaledImageSize.height, 0, 0, imageSize.width, imageSize.height, null);
            }
        }
        finally {
            g2d.setTransform(transform);
        }
    }
}

