/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class FadePanel
extends JPanel {
    private static final boolean DEBUG = false;
    protected BufferedImage preFadeImage;
    protected BufferedImage fadeToImage;
    private boolean fading = false;
    private float alpha = 0.0f;
    private Timer paintTimer;
    private final Object PAINT_LOCK = new Object();
    private JComponent currentContentPanel = null;
    private Dimension originalSize;
    private Dimension targetSize;
    private int steps;
    private float hChange;
    private float wChange;
    private int currentStep = 0;
    private boolean showingSmall;
    private JComponent large;
    private JComponent small;
    ActionListener repaintListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FadePanel.this.currentStep++;
            if (FadePanel.this.wChange != 0.0f || FadePanel.this.hChange != 0.0f) {
                Dimension newDim = new Dimension();
                newDim.width = (int)((float)((FadePanel)FadePanel.this).originalSize.width + FadePanel.this.wChange * (float)FadePanel.this.currentStep);
                newDim.height = (int)((float)((FadePanel)FadePanel.this).originalSize.height + FadePanel.this.hChange * (float)FadePanel.this.currentStep);
                FadePanel.this.currentContentPanel.setPreferredSize(newDim);
                FadePanel.this.currentContentPanel.setMaximumSize(newDim);
                FadePanel.this.currentContentPanel.setMinimumSize(newDim);
                FadePanel.this.revalidate();
            }
            FadePanel.this.repaint();
        }
    };

    public FadePanel(int totalFadeMS) {
        this.setLayout(new GridLayout(1, 1));
        this.steps = totalFadeMS / 25;
        int timerDelay = 0;
        if (this.steps > 0) {
            timerDelay = totalFadeMS / this.steps;
        }
        this.paintTimer = new Timer(timerDelay, this.repaintListener);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.large != null) {
            this.large.setBackground(bg);
        }
        if (this.small != null) {
            this.small.setBackground(bg);
        }
    }

    public void switchBetween(final JComponent small, final JComponent large, boolean showSmallestFirst) {
        this.large = large;
        this.small = small;
        this.showingSmall = showSmallestFirst;
        if (showSmallestFirst) {
            this.setContentComponent(small);
        } else {
            this.setContentComponent(large);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width = FadePanel.this.getWidth();
                int height = FadePanel.this.getHeight();
                if (FadePanel.this.showingSmall) {
                    if (width >= large.getPreferredSize().width && height >= large.getPreferredSize().height) {
                        FadePanel.this.showingSmall = !FadePanel.this.showingSmall;
                        FadePanel.this.setContentComponent(large);
                    }
                } else if (width < large.getPreferredSize().width || height < large.getPreferredSize().height) {
                    FadePanel.this.showingSmall = !FadePanel.this.showingSmall;
                    FadePanel.this.setContentComponent(small);
                }
            }
        });
    }

    public void setContentComponent(JComponent currentContentPanel) {
        this.setContentComponent(currentContentPanel, this.steps > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentComponent(final JComponent currentContentPanel, boolean animate) {
        Object object = this.PAINT_LOCK;
        synchronized (object) {
            if (currentContentPanel == null) {
                this.currentContentPanel = null;
                this.removeAll();
                this.revalidate();
            } else if (!animate || this.currentContentPanel == null) {
                if (!animate) {
                    this.removeAll();
                }
                this.currentContentPanel = currentContentPanel;
                this.add(currentContentPanel);
                this.revalidate();
            } else {
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.processTransition(currentContentPanel);
                    } else {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                FadePanel.this.processTransition(currentContentPanel);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private void processTransition(JComponent currentContentPanel) {
        Dimension size = this.getSize();
        this.preFade();
        this.remove(this.currentContentPanel);
        this.currentContentPanel = currentContentPanel;
        this.add(currentContentPanel);
        currentContentPanel.setSize(size);
        currentContentPanel.setPreferredSize(size);
        currentContentPanel.setDoubleBuffered(false);
        currentContentPanel.addNotify();
        currentContentPanel.validate();
        this.doFade();
    }

    public FadePanel() {
        this(500);
    }

    public void preFade() {
        this.preFadeImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g = this.preFadeImage.createGraphics();
        this.currentContentPanel.printAll(g);
        g.dispose();
        this.originalSize = this.currentContentPanel.getSize();
    }

    public void doFade() {
        this.targetSize = this.currentContentPanel.getPreferredSize();
        this.fadeToImage = new BufferedImage(this.targetSize.width, this.targetSize.height, 2);
        Graphics2D g = this.fadeToImage.createGraphics();
        this.currentContentPanel.printAll(g);
        g.dispose();
        this.fading = true;
        this.alpha = 0.0f;
        this.wChange = (float)(this.targetSize.width - this.originalSize.width) / (float)this.steps;
        this.hChange = (float)(this.targetSize.height - this.originalSize.height) / (float)this.steps;
        this.currentStep = 0;
        this.currentContentPanel.setPreferredSize(this.originalSize);
        this.currentContentPanel.setMinimumSize(this.originalSize);
        this.currentContentPanel.setMaximumSize(this.originalSize);
        this.repaintListener.actionPerformed(null);
        this.paintTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new FPPaint(g));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Object object = this.PAINT_LOCK;
        synchronized (object) {
            if (!this.fading) {
                super.paint(g);
            } else {
                this.alpha = 1.0f / (float)this.steps * (float)this.currentStep;
                Graphics2D g2d = (Graphics2D)g;
                g2d.setBackground(this.getBackground());
                g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
                if (this.alpha < 0.0f) {
                    this.alpha = 0.0f;
                }
                if (this.alpha > 1.0f) {
                    this.alpha = 1.0f;
                }
                Composite comp = g2d.getComposite();
                try {
                    g2d.setComposite(AlphaComposite.getInstance(3, 1.0f - this.alpha));
                    g2d.drawImage((Image)this.preFadeImage, 0, 0, null);
                    g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    g.drawImage(this.fadeToImage, 0, 0, this);
                }
                finally {
                    g2d.setComposite(comp);
                }
                if (this.currentStep >= this.steps) {
                    this.alpha = 0.0f;
                    this.fading = false;
                    this.currentContentPanel.setPreferredSize(null);
                    this.currentContentPanel.setMinimumSize(null);
                    this.currentContentPanel.setMaximumSize(null);
                    this.paintTimer.stop();
                    this.repaint();
                }
            }
        }
    }

    private class FPPaint
    implements Runnable {
        Graphics g;

        FPPaint(Graphics g) {
            this.g = g;
        }

        @Override
        public void run() {
            FadePanel.this.paint(this.g);
        }
    }
}

