/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.borders;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import javax.swing.border.Border;

public class TopDownGradientBorder
implements Border {
    private Insets margin;
    private Color bottomColor;
    private Color topColor;

    public TopDownGradientBorder(int top, int left, int bottom, int right, Color topColor, Color bottomColor) {
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.margin = new Insets(top, left, bottom, right);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(new GradientPaint(x, 0.0f, this.topColor, x, height, this.bottomColor));
        Area border = new Area(new Rectangle(x, y, width, height));
        border.subtract(new Area(new Rectangle(x + this.margin.left, y + this.margin.top, width - this.margin.left - this.margin.right, height - this.margin.top - this.margin.bottom)));
        g2d.fill(border);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.margin;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

