/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.borders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SimpleHelpFrame;

public class ImprovedRoundRectBorder
implements Border {
    protected Color borderColor;
    protected Color innerColor;
    protected Color outerColor;
    protected Color shadowColor;
    protected int radius = 4;
    protected int strokeWidth = 4;
    protected Paint overridePaint = null;
    protected Insets shadowInsets = new Insets(0, 0, 0, 0);
    protected int shadowWidth = 0;

    public ImprovedRoundRectBorder(Color borderColor, Color outerColor, Color innerColor) {
        this.innerColor = innerColor;
        this.outerColor = outerColor;
        this.borderColor = borderColor;
    }

    public void setShadow(Insets shadowInsets, Color shadowColor) {
        this.shadowInsets = shadowInsets;
        this.shadowWidth = shadowInsets.top;
        this.shadowWidth = Math.max(this.shadowWidth, shadowInsets.bottom);
        this.shadowWidth = Math.max(this.shadowWidth, shadowInsets.left);
        this.shadowWidth = Math.max(this.shadowWidth, shadowInsets.right);
        this.shadowWidth *= 2;
        this.shadowColor = shadowColor;
    }

    public void overrideWithPaint(Paint paint) {
        this.overridePaint = paint;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        int value = this.strokeWidth + this.radius / 2;
        return new Insets(this.shadowInsets.top + value, this.shadowInsets.left + value, this.shadowInsets.bottom + value, this.shadowInsets.right + value);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        for (int i = 0; i < clr1.length; ++i) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    private static void paintBorderShadow(Graphics2D g2, int shadowWidth, Shape clipShape, Color fromColor, Color toColor) {
        int sw;
        for (int i = sw = shadowWidth * 2; i >= 2; i -= 2) {
            float pct = (float)(sw - i) / (float)(sw - 1);
            g2.setColor(ImprovedRoundRectBorder.getMixedColor(fromColor, pct, toColor, 1.0f - pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(clipShape);
        }
    }

    private boolean shadowExists() {
        return this.shadowWidth > 0;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(comp);
        int arc = this.radius * 3;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int offset = 0;
        if (this.strokeWidth % 2 != 0) {
            offset = 1;
        }
        RoundRectangle2D.Double borderShape = new RoundRectangle2D.Double(x + this.strokeWidth / 2 + this.shadowInsets.left, y + this.strokeWidth / 2 + this.shadowInsets.top, width - this.strokeWidth - this.shadowInsets.left - this.shadowInsets.right - 1 + offset, height - this.strokeWidth - this.shadowInsets.top - this.shadowInsets.bottom - 1 + offset, arc, arc);
        if (this.outerColor != null) {
            g2.setColor(this.outerColor);
            g2.fillRect(x, y, insets.left, height);
            g2.fillRect(x, y, width, insets.top);
            g2.fillRect(x, height - insets.bottom, width, insets.bottom);
            g2.fillRect(width - insets.right, y, insets.right, height);
        }
        if (this.shadowExists()) {
            RoundRectangle2D.Double shadowShape = new RoundRectangle2D.Double(x + this.strokeWidth / 2 + this.shadowInsets.left + this.shadowWidth / 2 - this.shadowInsets.left, y + this.strokeWidth / 2 + this.shadowInsets.top + this.shadowWidth / 2 - this.shadowInsets.top, width - this.strokeWidth - this.shadowInsets.left - this.shadowInsets.right - 1 + offset - this.shadowWidth + this.shadowInsets.left + this.shadowInsets.right, height - this.strokeWidth - this.shadowInsets.top - this.shadowInsets.bottom - 1 + offset - this.shadowWidth + this.shadowInsets.top + this.shadowInsets.bottom, arc, arc);
            g2.setClip(0, 0, width, insets.top);
            ImprovedRoundRectBorder.paintBorderShadow(g2, this.shadowWidth, shadowShape, this.shadowColor, this.outerColor);
            g2.setClip(0, insets.top, insets.left, height - insets.top);
            ImprovedRoundRectBorder.paintBorderShadow(g2, this.shadowWidth, shadowShape, this.shadowColor, this.outerColor);
            g2.setClip(insets.left, height - insets.bottom, width - insets.left, insets.bottom);
            ImprovedRoundRectBorder.paintBorderShadow(g2, this.shadowWidth, shadowShape, this.shadowColor, this.outerColor);
            g2.setClip(width - insets.right, insets.top, insets.right, height - insets.top - insets.bottom);
            ImprovedRoundRectBorder.paintBorderShadow(g2, this.shadowWidth, shadowShape, this.shadowColor, this.outerColor);
        }
        g2.setStroke(new BasicStroke(this.strokeWidth));
        if (this.innerColor != null) {
            int borderX = x + this.shadowInsets.left;
            int borderY = y + this.shadowInsets.top;
            int borderWidth = width - this.shadowInsets.left - this.shadowInsets.right;
            int borderHeight = height - this.shadowInsets.top - this.shadowInsets.bottom;
            Insets borderInsets = new Insets(insets.top - this.shadowInsets.top, insets.left - this.shadowInsets.left, insets.bottom - this.shadowInsets.bottom, insets.right - this.shadowInsets.right);
            g2.setColor(this.innerColor);
            g2.setClip(borderX, borderY, borderWidth, borderInsets.top);
            g2.fill(borderShape);
            g2.setClip(borderX, borderY, borderInsets.left, borderHeight);
            g2.fill(borderShape);
            g2.setClip(borderX + borderWidth - borderInsets.right, borderY, borderInsets.right, borderHeight);
            g2.fill(borderShape);
            g2.setClip(borderX, height - insets.bottom, borderWidth, borderInsets.bottom);
            g2.fill(borderShape);
        }
        g2.setClip(x, y, width, height);
        g2.setColor(this.borderColor);
        if (this.overridePaint != null) {
            g2.setPaint(this.overridePaint);
        }
        g2.draw(borderShape);
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        ((Window)frame).setSize(800, 500);
        frame.setDefaultCloseOperation(3);
        ImprovedRoundRectBorder test = new ImprovedRoundRectBorder(Color.GRAY, Color.WHITE, Color.LIGHT_GRAY);
        test.setShadow(new Insets(10, 10, 10, 10), Color.LIGHT_GRAY);
        test.setRadius(60);
        test.setWidth(10);
        JPanel tmp = new JPanel();
        tmp.setBorder(test);
        tmp.setBackground(Color.LIGHT_GRAY);
        RoundBorderPanel outer = new RoundBorderPanel();
        outer.setLayout(new GridLayout(1, 1));
        outer.setBackground(Color.white);
        outer.add(tmp);
        frame.getContentPane().add(outer);
        frame.setVisible(true);
    }
}

