/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.Timer;
import utils.stream.OpenByteArrayOutputStream;

public class TextFieldPrintStream
extends PrintStream
implements ActionListener {
    int max = 1000000;
    boolean update = true;
    String header;
    JTextArea area;

    public TextFieldPrintStream(JTextArea area, String header) {
        super(new OpenByteArrayOutputStream());
        this.area = area;
        this.header = header;
        new Timer(100, this).start();
    }

    public void setMax(int max) {
        this.max = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.update) {
            return;
        }
        TextFieldPrintStream textFieldPrintStream = this;
        synchronized (textFieldPrintStream) {
            OpenByteArrayOutputStream bout = (OpenByteArrayOutputStream)this.out;
            if (bout.size() > 0) {
                String text;
                this.area.append(new String(bout.getByteArray(), 0, bout.size()));
                if ((double)this.area.getDocument().getLength() > (double)this.max * 1.1 && (double)(text = this.area.getText()).length() > (double)this.max * 1.1) {
                    this.area.setText("--- Trimmed to " + this.max + " ---\r\n" + this.header + text.substring(text.length() - this.max, text.length()));
                }
                bout.reset();
                this.area.setCaretPosition(this.area.getDocument().getLength());
            }
        }
    }

    public void setUpdate(boolean b) {
        this.update = b;
    }
}

