/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.swing.JPanel;
import utils.ostools.OS;
import utils.swing.MiniStatGraph;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpFrame;

public class MiniStatGraphPanel
extends JPanel {
    private ArrayList<MiniStatGraphInterface> graphs = new ArrayList();
    private ArrayList<double[]> data = new ArrayList();

    public MiniStatGraphPanel(MiniStatGraphInterface graph) {
        this.setBackground(Color.white);
        this.graphs.add(graph);
    }

    public MiniStatGraphPanel() {
    }

    public void addGraph(MiniStatGraphInterface graph, double[] dat) {
        this.graphs.add(graph);
        this.data.add(dat);
    }

    public void setData(double[] dat) {
        this.data.clear();
        this.data.add(dat);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Insets insets = this.getInsets();
        int xoff = insets.left;
        int yoff = insets.right;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        AffineTransform affineTransform = SwingUtil.prepareForRetina(g2d);
        try {
            for (int i = 0; i < this.graphs.size(); ++i) {
                MiniStatGraphInterface graph = this.graphs.get(i);
                double[] dat = null;
                if (i < this.data.size()) {
                    dat = this.data.get(i);
                }
                if (graph == null || dat == null) continue;
                if (OS.isOSXRetina()) {
                    graph.paint(g, dat, xoff * 2, yoff * 2, width * 2, height * 2, i == 0);
                    continue;
                }
                graph.paint(g, dat, xoff, yoff, width, height, i == 0);
            }
        }
        finally {
            g2d.setTransform(affineTransform);
        }
    }

    public static void main(String[] args) {
        double[] data = new double[30];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i % 2 == 0 ? 0.0 : 100.0;
        }
        MiniStatGraphPanel cpuGraph = new MiniStatGraphPanel(new MiniStatGraph(Color.white, MiniStatGraph.BLUE, 100.0));
        cpuGraph.setBorder(SHBorderFactory.createEmptyBorder(20, 20, 20, 20));
        cpuGraph.setData(data);
        SimpleHelpFrame testFrame = SimpleHelpFrame.getTestFrame();
        testFrame.getContentPane().add(cpuGraph);
        testFrame.setVisible(true);
    }

    public static interface MiniStatGraphInterface {
        public void paint(Graphics var1, double[] var2, int var3, int var4, int var5, int var6, boolean var7);
    }
}

