/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import utils.swing.MiniStatGraphPanel;

public class MiniStatGraph
implements MiniStatGraphPanel.MiniStatGraphInterface {
    private static final Color EXTREME_COLOR = new Color(255, 180, 167);
    private static final Color EXTREME_COLOR_DARKER = new Color(255, 138, 120);
    public static final Color GREEN_VERY_DARK = new Color(51, 140, 34);
    public static final Color[] GREEN = new Color[]{new Color(160, 238, 160), new Color(74, 242, 74)};
    public static final Color[] BLUE = new Color[]{new Color(160, 181, 255), new Color(104, 128, 255)};
    public static final Color[] YELLOW = new Color[]{new Color(242, 225, 174), new Color(238, 195, 119)};
    public static final Color[] RED = new Color[]{EXTREME_COLOR, EXTREME_COLOR_DARKER};
    Color bg;
    Color fillColor;
    Color lineColor;
    double max;
    private static final boolean DRAW_TOP_TINTED_VERSION = false;

    public MiniStatGraph(Color bg, Color fillColor, Color lineColor, double max) {
        this.bg = bg;
        this.fillColor = fillColor;
        this.lineColor = lineColor;
        this.max = max;
    }

    public MiniStatGraph(Color bg, Color[] colors, double max) {
        this(bg, colors[0], colors[1], max);
    }

    @Override
    public void paint(Graphics g, double[] dat, int xoff, int yoff, int width, int height, boolean b) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g = g.create(xoff, yoff, width, height);
        g.setColor(this.bg);
        g.fillRect(0, 0, width, height);
        g.setColor(this.fillColor);
        Polygon pp = new Polygon();
        pp.addPoint(0, height);
        pp.addPoint(0, height);
        double dheight = height;
        double dwidth = width;
        double wstep = dwidth / (double)(dat.length - 1);
        boolean isRed = false;
        int prevx = 0;
        int prevy = 0;
        int startx = -1;
        for (int i = 0; i < dat.length; ++i) {
            boolean pointIsRed;
            boolean bl = pointIsRed = dat[i] / this.max > 0.8;
            if (i > 0) {
                boolean bl2 = pointIsRed = pointIsRed || dat[i - 1] / this.max > 0.8;
            }
            if (i == 0) {
                isRed = pointIsRed;
            } else if (pointIsRed != isRed) {
                pp.addPoint(prevx, height);
                pp.addPoint(startx, height);
                if (isRed) {
                    g.setColor(EXTREME_COLOR);
                } else {
                    g.setColor(this.fillColor);
                }
                g.drawPolygon(pp);
                g.fillPolygon(pp);
                if (isRed) {
                    g.setColor(EXTREME_COLOR_DARKER);
                } else {
                    g.setColor(this.lineColor);
                }
                int x = 0;
                int y = 0;
                for (int ii = 1; ii < pp.npoints - 2; ++ii) {
                    if (ii == 1) {
                        x = pp.xpoints[ii];
                        y = pp.ypoints[ii];
                        continue;
                    }
                    g.drawLine(x, y, pp.xpoints[ii], pp.ypoints[ii]);
                    x = pp.xpoints[ii];
                    y = pp.ypoints[ii];
                }
                pp = new Polygon();
                pp.addPoint(prevx, height);
                pp.addPoint(prevx, prevy);
                startx = -1;
                isRed = pointIsRed;
            }
            prevx = (int)((double)i * wstep);
            prevy = height - (int)(dheight * (dat[i] / this.max));
            if (startx == -1) {
                startx = prevx;
            }
            pp.addPoint(prevx, prevy);
        }
        if (pp.npoints > 0) {
            pp.addPoint(prevx, height);
            pp.addPoint(startx, height);
            if (isRed) {
                g.setColor(EXTREME_COLOR);
            } else {
                g.setColor(this.fillColor);
            }
            g.drawPolygon(pp);
            g.fillPolygon(pp);
        }
        if (isRed) {
            g.setColor(EXTREME_COLOR_DARKER);
        } else {
            g.setColor(this.lineColor);
        }
        int x = 0;
        int y = 0;
        for (int i = 1; i < pp.npoints - 2; ++i) {
            if (i == 1) {
                x = pp.xpoints[i];
                y = pp.ypoints[i];
                continue;
            }
            g.drawLine(x, y, pp.xpoints[i], pp.ypoints[i]);
            x = pp.xpoints[i];
            y = pp.ypoints[i];
        }
        g.setColor(new Color(180, 180, 180, 255));
        g.drawRect(0, 0, width - 1, height - 1);
    }
}

