/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class DirHash {
    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        System.out.println(DirHash.hashLong(new File("/tmp/test"), false));
        System.out.println(System.currentTimeMillis() - start);
    }

    public static long hashNoDataLong(File[] fileList, boolean includeLastmod) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.put(DirHash.hashNoData(fileList, includeLastmod));
        buffer.flip();
        return buffer.getLong();
    }

    public static long hashLong(File[] fileList, boolean includeLastmod) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.put(DirHash.hash(fileList, includeLastmod));
        buffer.flip();
        return buffer.getLong();
    }

    public static long hashLong(File f, boolean includeLastmod) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.put(DirHash.hash(f, includeLastmod));
        buffer.flip();
        return buffer.getLong();
    }

    public static byte[] hash(File[] files, boolean includeLastmod) throws IOException {
        try {
            MessageDigest dig = MessageDigest.getInstance("SHA-256");
            for (File f : files) {
                DirHash.hash(dig, f, includeLastmod, true);
            }
            byte[] dat = dig.digest();
            return dat;
        }
        catch (NoSuchAlgorithmException x) {
            IOException xx = new IOException("Failed to load hash function");
            xx.initCause(x);
            throw xx;
        }
    }

    public static byte[] hashNoData(File[] files, boolean includeLastmod) throws IOException {
        try {
            MessageDigest dig = MessageDigest.getInstance("SHA-256");
            for (File f : files) {
                DirHash.hash(dig, f, includeLastmod, false);
            }
            byte[] dat = dig.digest();
            return dat;
        }
        catch (NoSuchAlgorithmException x) {
            IOException xx = new IOException("Failed to load hash function");
            xx.initCause(x);
            throw xx;
        }
    }

    public static byte[] hash(File f, boolean includeLastmod) throws IOException {
        try {
            MessageDigest dig = MessageDigest.getInstance("SHA-256");
            if (f.isDirectory()) {
                Object[] files = f.listFiles();
                Arrays.sort(files);
                for (Object ff : files) {
                    DirHash.hash(dig, (File)ff, includeLastmod, true);
                }
            } else {
                DirHash.hash(dig, f, includeLastmod, true);
            }
            byte[] dat = dig.digest();
            return dat;
        }
        catch (NoSuchAlgorithmException x) {
            IOException xx = new IOException("Failed to load hash function");
            xx.initCause(x);
            throw xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hash(MessageDigest dig, File f, boolean includeLastmod, boolean includeData) throws IOException {
        dig.update(f.getName().getBytes("UTF8"));
        if (f.isDirectory()) {
            Object[] files = f.listFiles();
            Arrays.sort(files);
            for (Object ff : files) {
                DirHash.hash(dig, (File)ff, includeLastmod, includeData);
            }
        } else {
            if (includeLastmod) {
                long lastmod = f.lastModified();
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putLong(lastmod);
                dig.update(buffer.array());
            }
            if (includeData) {
                if (DirHash.isSymlink(f)) {
                    System.out.println("Skipping symlink: " + f);
                } else {
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
                        byte[] buf = new byte[1024000];
                        int n = 0;
                        while (n != -1) {
                            n = ((InputStream)in).read(buf);
                            if (n <= 0) continue;
                            dig.update(buf, 0, n);
                        }
                    }
                    catch (Exception x) {
                        System.out.println("Warning: unable to include data from " + f + " in hash: " + x);
                    }
                }
            }
        }
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }
}

