/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

public class CharStack {
    char[] cs;
    int cslen;
    int index;
    int[] marks = new int[10];
    int markptr = 0;
    boolean fakingEndTag = false;
    int lastStartTag = -1;
    int lastEndTag = -1;
    boolean forward = true;
    char[] rev;
    static String[] eol = new String[]{"\n", "\r"};

    public void popUntilNumber() {
        while (!this.isEmpty() && !Character.isDigit(this.peek())) {
            this.pop();
        }
    }

    public String popLine(boolean returnString) {
        String s = this.popUntil(eol, returnString);
        if (s != null && s.length() > 0) {
            char c = s.charAt(s.length() - 1);
            s = s.substring(0, s.length() - 1);
            if (c == '\r' && this.peek() == '\n') {
                this.pop();
            }
        }
        return s;
    }

    public String popUntil(String[] stop, boolean returnString) {
        char[][] ars = new char[stop.length][];
        for (int i = 0; i < stop.length; ++i) {
            ars[i] = stop[i].toCharArray();
        }
        return this.popUntil(ars, returnString);
    }

    public String popUntil(char[][] stop, boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        boolean matched = false;
        int z = 0;
        int zmatch = 0;
        do {
            for (z = 0; z < stop.length; ++z) {
                for (int k = 0; k < stop[z].length && n + k < this.cslen && this.cs[n + k] == stop[z][k]; ++k) {
                    if (k != stop[z].length - 1) continue;
                    matched = true;
                    zmatch = z;
                }
            }
            if (!matched) continue;
            n += stop[zmatch].length;
            break;
        } while (++n != this.cslen);
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            if (matched) {
                String ret = this.weebleString(this.cs, this.index, n - this.index);
                this.index = n;
                return ret;
            }
            String ret = this.weebleString(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    private static char[] cloneReversed(char[] tmp) {
        char[] ntmp = new char[tmp.length];
        int ni = tmp.length - 1;
        for (int i = 0; i < tmp.length; ++i) {
            ntmp[ni] = tmp[i];
            --ni;
        }
        return ntmp;
    }

    private static char[] cloneReversed(char[] tmp, int off, int len) {
        char[] ntmp = new char[len];
        for (int i = 0; i < len; ++i) {
            ntmp[len - 1 - i] = tmp[off + i];
        }
        return ntmp;
    }

    private static char[] reverseInPlace(char[] tmp) {
        int len = tmp.length;
        int lenm1 = tmp.length - 1;
        for (int i = 0; i < len; ++i) {
            char c = tmp[i];
            tmp[i] = tmp[lenm1 - i];
            tmp[lenm1 - i] = c;
        }
        return tmp;
    }

    public CharStack switchDirection() {
        if (this.forward) {
            this.backward();
        } else {
            this.forward();
        }
        return this;
    }

    private void changeDirection() {
        this.forward = !this.forward;
        char[] tmp = this.rev;
        this.rev = this.cs;
        this.cs = tmp;
        this.index = this.cslen - this.index;
    }

    public CharStack backward() {
        if (this.forward) {
            if (this.rev == null) {
                this.rev = CharStack.cloneReversed(this.cs);
            }
            this.changeDirection();
        }
        return this;
    }

    private String weebleString(char[] cs, int off, int len) {
        if (this.forward) {
            return new String(cs, off, len);
        }
        return new String(CharStack.cloneReversed(cs, off, len));
    }

    public CharStack forward() {
        if (!this.forward) {
            this.changeDirection();
        }
        return this;
    }

    public boolean isNextNumber() {
        try {
            this.peekNumber();
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public CharStack(char[] s) {
        this.cs = s;
        this.cslen = s.length;
        this.index = 0;
    }

    public CharStack(String s) {
        this.cs = s.toCharArray();
        this.cslen = this.cs.length;
        this.index = 0;
    }

    public CharStack(String s, int index) {
        this.cs = s.toCharArray();
        this.cslen = this.cs.length;
        this.index = index;
    }

    public boolean isEmpty() {
        return this.index >= this.cslen;
    }

    public char peek() {
        return this.cs[this.index];
    }

    public char pop() {
        return this.cs[this.index++];
    }

    public void popToEnd() {
        this.index = this.cslen;
    }

    public String popToEnd(boolean returnString) {
        String ret = returnString ? new String(this.cs, this.index, this.cslen - this.index) : null;
        this.popToEnd();
        return ret;
    }

    public void mark() {
        this.marks[this.markptr++] = this.index;
        if (this.markptr == this.marks.length) {
            int[] tmp = new int[this.marks.length * 2];
            System.arraycopy(this.marks, 0, tmp, 0, this.marks.length);
            this.marks = tmp;
        }
    }

    public String getStringSinceMark() {
        return new String(this.cs, this.marks[this.markptr - 1], this.index - this.marks[this.markptr - 1]);
    }

    public CharStack replaceStringSinceMark(String rep) {
        String before = new String(this.cs, 0, this.marks[this.markptr - 1]);
        String after = new String(this.cs, this.index, this.cs.length - this.index);
        CharStack cs = new CharStack(before + rep + after);
        cs.index = before.length() + rep.length();
        return cs;
    }

    public void resetToMark() {
        --this.markptr;
        if (this.markptr == -1) {
            this.markptr = 0;
        }
        this.index = this.marks[this.markptr];
        this.fakingEndTag = false;
    }

    public void popMark() {
        --this.markptr;
        if (this.markptr == -1) {
            this.markptr = 0;
        }
    }

    public double peekNumber() throws NumberFormatException {
        int tmp = this.index;
        double d = this.popNumber();
        this.index = tmp;
        return d;
    }

    public long popInteger() throws NumberFormatException {
        int n = this.index;
        char c = this.cs[n];
        if (c == '-') {
            c = this.cs[++n];
        }
        while (Character.isDigit(c) && ++n != this.cslen) {
            c = this.cs[n];
        }
        if (n == this.index) {
            throw new NumberFormatException("no digits found " + new String(this.cs, this.index, Math.min(this.index + 5, this.cslen) - this.index));
        }
        long d = Long.parseLong(new String(this.cs, this.index, n - this.index));
        this.index = n;
        return d;
    }

    public double popNumber(boolean skipWhitespace) throws NumberFormatException {
        this.popWhitespace();
        return this.popNumber();
    }

    public double popNumber() throws NumberFormatException {
        int n = this.index;
        char c = this.cs[n];
        if (c == '-') {
            c = this.cs[++n];
        }
        while ((Character.isDigit(c) || c == '.') && ++n != this.cslen) {
            c = this.cs[n];
        }
        if (n != this.cslen && (this.cs[n] == 'E' || this.cs[n] == 'e') && ++n != this.cslen) {
            if (this.cs[n] == '-') {
                ++n;
            }
            while (Character.isDigit(this.cs[n]) && ++n != this.cslen) {
            }
        }
        if (n == this.index) {
            throw new NumberFormatException("no digits found " + new String(this.cs, this.index, Math.min(this.index + 5, this.cslen) - this.index));
        }
        double d = Double.parseDouble(new String(this.cs, this.index, n - this.index));
        this.index = n;
        return d;
    }

    public void popWhitespace() {
        if (this.index == this.cslen) {
            return;
        }
        int n = this.index;
        char ch = this.cs[n];
        while ((ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') && ++n != this.cslen) {
            ch = this.cs[n];
        }
        this.index = n;
    }

    public String popText(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        while (this.cs[n] != ' ' && this.cs[n] != '\t' && this.cs[n] != '\r' && this.cs[n] != '\n' && ++n != this.cslen) {
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = new String(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public void popUntil(String stop) {
        this.popUntil(stop.toCharArray(), false);
    }

    public String popUntil(String stop, boolean returnString) {
        return this.popUntil(stop.toCharArray(), returnString);
    }

    public String popUntil(char[] stop, boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        boolean matched = false;
        do {
            for (int k = 0; k < stop.length && n + k < this.cslen && this.cs[n + k] == stop[k]; ++k) {
                if (k != stop.length - 1) continue;
                matched = true;
            }
            if (!matched) continue;
            n += stop.length;
            break;
        } while (++n != this.cslen);
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            if (matched) {
                String ret = new String(this.cs, this.index, n - stop.length - this.index);
                this.index = n;
                return ret;
            }
            String ret = new String(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popUntil(char stop, boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        boolean matched = true;
        while (this.cs[n] != stop) {
            if (++n != this.cslen) continue;
            matched = false;
            break;
        }
        if (n != this.cslen) {
            ++n;
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            if (n == this.cslen && !matched) {
                String ret = new String(this.cs, this.index, n - this.index);
                this.index = n;
                return ret;
            }
            String ret = new String(this.cs, this.index, n - 1 - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popXmlText(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        boolean hasEscaped = false;
        while (this.cs[n] != '<') {
            if (this.cs[n] == '&') {
                hasEscaped = true;
            }
            if (++n != this.cslen) continue;
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = new String(this.cs, this.index, n - this.index);
            if (hasEscaped) {
                ret = CharStack.fromXMLString(ret);
            }
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popJavaFullClassname(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        char ch = this.cs[n];
        while ((ch > '/' && ch < ':' || ch > '@' && ch < '[' || ch > '`' && ch < '{' || ch == '_' || ch == '.') && ++n != this.cslen) {
            ch = this.cs[n];
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = new String(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popXmlIdentifier(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        char ch = this.cs[n];
        while ((ch > '/' && ch < ';' || ch > '@' && ch < '[' || ch > '`' && ch < '{' || ch == '_') && ++n != this.cslen) {
            ch = this.cs[n];
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = new String(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popXmlQuoted(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        char quote = this.pop();
        boolean hasEscaped = false;
        int n = this.index;
        while (this.cs[n] != quote) {
            if (this.cs[n] == '&') {
                hasEscaped = true;
            }
            if (++n != this.cslen) continue;
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = new String(this.cs, this.index, n - this.index);
            if (hasEscaped) {
                ret = CharStack.fromXMLString(ret);
            }
            this.index = n + 1;
            return ret;
        }
        this.index = n + 1;
        return null;
    }

    public String popXmlElementStart() {
        this.popXmlText(false);
        if (this.isEmpty()) {
            return "";
        }
        int startIndex = this.index;
        this.pop();
        if (this.peek() == '/') {
            this.pop();
            this.popWhitespace();
            String id = this.popXmlIdentifier(true);
            return "/" + id;
        }
        this.popWhitespace();
        this.lastStartTag = startIndex;
        String id = this.popXmlIdentifier(true);
        if (this.fakingEndTag) {
            this.index = this.lastEndTag;
            return "/" + id;
        }
        return id;
    }

    public void popXmlAttributes() {
        String attr = this.popXmlAttributeName();
        while (attr.length() > 0) {
            this.popWhitespace();
            this.pop();
            this.popWhitespace();
            this.popXmlQuoted(false);
            attr = this.popXmlAttributeName();
        }
    }

    public String popXmlAttributeName() {
        this.popWhitespace();
        return this.popXmlIdentifier(true);
    }

    public String popXmlAttributeValue() {
        this.popWhitespace();
        this.pop();
        this.popWhitespace();
        return this.popXmlQuoted(true);
    }

    public void popXmlElementEnd() {
        this.popWhitespace();
        if (this.fakingEndTag) {
            this.fakingEndTag = false;
            this.index = this.lastEndTag;
        }
        if (this.peek() == '/') {
            this.pop();
            this.fakingEndTag = true;
            this.lastEndTag = this.index;
            this.pop();
            this.index = this.lastStartTag;
        } else {
            this.fakingEndTag = false;
            this.pop();
        }
    }

    public String popXmlSubTree(boolean returnString) {
        int begin = this.index;
        boolean done = false;
        while (!done) {
            this.popXmlText(false);
            int tmp = this.index;
            String start = this.popXmlElementStart();
            if (start.length() > 0) {
                if (start.charAt(0) == '/') {
                    this.index = tmp;
                    done = true;
                    continue;
                }
                this.popXmlAttributes();
                this.popXmlElementEnd();
                this.popXmlSubTree(false);
                this.popXmlElementStart();
                this.popXmlElementEnd();
                continue;
            }
            done = true;
        }
        this.popXmlText(false);
        if (returnString) {
            return new String(this.cs, begin, this.index - begin);
        }
        return null;
    }

    public String toFullString() {
        return new String(this.cs);
    }

    public String toString() {
        return new String(this.cs, this.index, Math.min(this.index + 20, this.cslen) - this.index) + "...";
    }

    public String toString(int N) {
        return new String(this.cs, this.index, Math.min(this.index + N, this.cslen) - this.index) + "...";
    }

    public String toString(char c) {
        int loc;
        for (loc = this.index; loc < this.cs.length && this.cs[loc] != '\n'; ++loc) {
        }
        return new String(this.cs, this.index, Math.min(loc, this.cslen) - this.index) + "...";
    }

    public void debugStack(String s) {
        System.err.println("STACK PARSING=" + s);
        System.err.println("STACK SIZE=" + this.cslen);
        System.err.println("STACK PTR=" + this.index);
        System.err.println("STACK FAKE END=" + this.fakingEndTag);
        System.err.println("STACK CONTENTS=" + new String(this.cs, this.index, Math.min(this.index + 20, this.cslen) - this.index) + "...");
    }

    public String getStack() {
        return new String(this.cs, 0, this.cslen);
    }

    private static void testXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(" <\tUSAddress  \t country= \"US\">");
        sb.append(" TEXT");
        sb.append(" </USAddress> TEXT &lt;&gt;&quot;&apos;&amp;");
        CharStack cs = new CharStack(sb.toString());
        String tmp = cs.popXmlElementStart();
        if (!tmp.equals("USAddress")) {
            System.err.println("Popped element incorrectly - [" + tmp + "]");
        }
        if (!(tmp = cs.popXmlAttributeName()).equals("country")) {
            System.err.println("Popped attribute name incorrectly - [" + tmp + "]");
        }
        if (!(tmp = cs.popXmlAttributeValue()).equals("US")) {
            System.err.println("Popped attribute value incorrectly - [" + tmp + "]");
        }
        cs.popXmlElementEnd();
        tmp = cs.popXmlText(true);
        if (!tmp.equals(" TEXT ")) {
            System.err.println("Popped text incorrectly - [" + tmp + "]");
        }
        if (!(tmp = cs.popXmlElementStart()).equals("/USAddress")) {
            System.err.println("Popped element incorrectly - [" + tmp + "]");
        }
        cs.popXmlElementEnd();
        tmp = cs.popXmlElementStart();
        if (tmp.length() > 0) {
            System.err.println("popped element name from text - [" + tmp + "]");
        }
        if (!cs.isEmpty()) {
            System.err.println("Finished reading all XML but not empty??");
        }
        sb = new StringBuffer();
        sb.append("OTHER TEXT1 <MINI_NODE /> OTHER TEXT2 <N1><N2><MINI_NODE2 /></N2></N1> OTHER TEXT3 </flinder>");
        cs = new CharStack(sb.toString());
        String ret = cs.popXmlSubTree(true);
        if (!ret.equals("OTHER TEXT1 <MINI_NODE /> OTHER TEXT2 <N1><N2><MINI_NODE2 /></N2></N1> OTHER TEXT3 ")) {
            System.out.println("Popped subtree incorrectly:[" + ret + "]");
        } else {
            System.out.println("Popped subtree correctly:" + ret);
        }
        String soapTest = "   <result xsi:type=\"ns2:string\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns2=\"http://www.w3.org/2001/XMLSchema\">ni hao</result>";
        cs = new CharStack(soapTest);
        cs.popXmlText(false);
        tmp = cs.popXmlElementStart();
        if (!tmp.equals("result")) {
            System.out.println("popped SOAP element incorrectly - [" + tmp + "]");
        } else {
            System.out.println("popped SOAP element OK - [" + tmp + "]");
        }
    }

    public static void main(String[] args) {
        String test = "Hello, this is a test}";
        CharStack stack = new CharStack(test.toCharArray());
        try {
            System.out.println("Test String = " + test);
            System.out.println("Running stack.popUntil('}',true);....");
            System.out.println("Result = " + stack.popUntil('}', true));
            System.out.println();
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            test = "Hello, this is a test";
            stack = new CharStack(test.toCharArray());
            System.out.println("Test String = " + test);
            System.out.println("Running stack.popUntil('}',true);....");
            System.out.println("Result = " + stack.popUntil('}', true));
            System.out.println();
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test = "Hello, this} is a test";
        stack = new CharStack(test.toCharArray());
        System.out.println("Test String = " + test);
        System.out.println("Running stack.popUntil('}',true);....");
        System.out.println("Result = " + stack.popUntil('}', true));
        System.out.println();
        System.out.println();
        test = "Hello, this}} is a test";
        stack = new CharStack(test.toCharArray());
        System.out.println("Test String = " + test);
        System.out.println("Running stack.popUntil('}',true);....");
        System.out.println("Result = " + stack.popUntil('}', true));
        System.out.println("Result = " + stack.popUntil('}', true));
        System.out.println();
        System.out.println();
        test = "}Hello, this is a test";
        stack = new CharStack(test.toCharArray());
        System.out.println("Test String = " + test);
        System.out.println("Running stack.popUntil('}',true);....");
        System.out.println("Result = " + stack.popUntil('}', true));
    }

    public static String fromXMLString(String s) {
        char[] cs = s.toCharArray();
        int cslen = cs.length;
        StringBuffer ret = new StringBuffer();
        char cs0 = '\u0000';
        char cs1 = '\u0000';
        char cs2 = '\u0000';
        char cs3 = '\u0000';
        char cs4 = '\u0000';
        char cs5 = '\u0000';
        for (int i = 0; i < cslen; ++i) {
            cs0 = cs[i];
            if (cs0 == '&') {
                int len = cslen - i;
                if (len > 3) {
                    cs1 = cs[i + 1];
                    cs2 = cs[i + 2];
                    cs3 = cs[i + 3];
                    if (cs1 == '#') {
                        int end_parse = CharStack.charArrayIndexOf(';', cs, cslen, i + 1);
                        if (end_parse != -1) {
                            char ccode = (char)Integer.parseInt(new String(cs, i + 2, end_parse - (i + 2)));
                            ret.append(String.valueOf(ccode));
                            i = end_parse;
                        }
                    } else if (cs1 == 'l' && cs2 == 't' && cs3 == ';') {
                        ret.append('<');
                        i += 3;
                    } else if (cs1 == 'g' && cs2 == 't' && cs3 == ';') {
                        ret.append('>');
                        i += 3;
                    }
                }
                if (len > 4) {
                    cs4 = cs[i + 4];
                    if (cs1 == 'a' && cs2 == 'm' && cs3 == 'p' && cs4 == ';') {
                        ret.append('&');
                        i += 4;
                    }
                }
                if (len <= 5) continue;
                cs5 = cs[i + 5];
                if (cs1 == 'q' && cs2 == 'u' && cs3 == 'o' && cs4 == 't' && cs5 == ';') {
                    ret.append('\"');
                    i += 5;
                    continue;
                }
                if (cs1 != 'a' || cs2 != 'p' || cs3 != 'o' || cs4 != 's' || cs5 != ';') continue;
                ret.append('\'');
                i += 5;
                continue;
            }
            ret.append(cs0);
        }
        return ret.toString();
    }

    private static int charArrayIndexOf(char c, char[] cs, int cslen, int index) {
        for (int i = index; i < cslen; ++i) {
            if (cs[i] != c) continue;
            return i;
        }
        return -1;
    }
}

