/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.SSLServerSocketFactory;
import utils.progtools.arrays.ArrayUtils;
import utils.stream.StreamUtils;

public class TinyWebServer {
    public static boolean DEBUG = true;
    public static boolean DEBUG404 = false;
    int port;
    File base;
    TcpServer tcp;
    boolean listDirs;
    boolean listDotFiles = false;
    protected String slashRedirect;
    ResourceHandler reshandler;
    boolean useResourceHandlerOnly;

    protected boolean allowCaching() {
        return false;
    }

    public TinyWebServer(File base) throws IOException {
        String tmp = base.getAbsolutePath();
        if (tmp.endsWith("..")) {
            tmp = tmp.substring(0, tmp.length() - 2);
        }
        if (tmp.endsWith(".")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (tmp.endsWith("/") && tmp.length() > 1) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (tmp.endsWith("\\") && tmp.length() > 1) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        this.base = new File(tmp);
    }

    public void addTcpPort(int port) throws IOException {
        TcpServer tcp = new TcpServer(port, false);
        tcp.start();
    }

    public void addSslPort(int port) throws IOException {
        TcpServer tcp = new TcpServer(port, true);
        tcp.start();
    }

    public void setListDirs(boolean b) {
        this.listDirs = b;
    }

    public void setSlashRedirect(String s) {
        this.slashRedirect = s;
    }

    public TinyWebServer(int port, File base) throws IOException {
        this(port, base, true, null);
    }

    public TinyWebServer(int port, File base, boolean listDirs, String slashRedirect) throws IOException {
        System.out.println("TinyWebServer launching (" + port + "), " + base);
        this.port = port;
        this.listDirs = listDirs;
        this.slashRedirect = slashRedirect;
        String tmp = base.getAbsolutePath();
        if (tmp.endsWith("..")) {
            tmp = tmp.substring(0, tmp.length() - 2);
        }
        if (tmp.endsWith(".")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (tmp.endsWith("/") && tmp.length() > 1) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (tmp.endsWith("\\") && tmp.length() > 1) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        this.base = new File(tmp);
        this.tcp = new TcpServer(port, false);
        this.tcp.start();
    }

    public void setResourceHandler(ResourceHandler handler) {
        this.reshandler = handler;
    }

    public void useResourceHandlerOnly(boolean b) {
        this.useResourceHandlerOnly = b;
    }

    public int getPort() {
        return this.port;
    }

    public void shutdown() {
        System.out.println("[TinyWebServer] shutdown not implemented");
    }

    public File getFileForResource(String res) {
        int index = res.indexOf(63);
        if (index != -1) {
            res = res.substring(0, index);
        }
        File file = new File(this.base, res);
        return file;
    }

    private static ByteArrayOutputStream zipUp(File f) throws IOException {
        byte[] buf = new byte[100000];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(bout);
        TinyWebServer.recursiveZip("", f, zout, buf);
        zout.finish();
        zout.close();
        return bout;
    }

    private static void recursiveZip(String folder, File f, ZipOutputStream out, byte[] buf) throws IOException {
        String name = f.getName();
        name = name.replace('\\', '/');
        if (f.isDirectory()) {
            if (!name.endsWith("/")) {
                name = name + "/";
            }
        } else if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        name = folder + name;
        System.out.println("Adding " + name);
        ZipEntry ze = new ZipEntry(name);
        out.putNextEntry(ze);
        if (f.isFile()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            int n = 0;
            while (n != -1) {
                n = ((InputStream)in).read(buf);
                if (n <= 0) continue;
                out.write(buf, 0, n);
            }
            ((InputStream)in).close();
        }
        out.closeEntry();
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                TinyWebServer.recursiveZip(name, files[i], out, buf);
            }
        }
    }

    public static String getMimeTypeFor(String path) {
        return MimeTypes.getMimeTypeFor(path);
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args[0].equals("nolist")) {
                args = ArrayUtils.popFirst(args);
                System.out.println("Not listing directories");
                if (args[0].equalsIgnoreCase("standard")) {
                    TinyWebServer tws = new TinyWebServer(80, new File(args[1]), false, null);
                    tws.addSslPort(443);
                } else {
                    new TinyWebServer(Integer.parseInt(args[0]), new File(args[1]), false, null);
                }
            } else if (args[0].equalsIgnoreCase("standard")) {
                TinyWebServer tws = new TinyWebServer(80, new File(args[1]));
                tws.addSslPort(443);
            } else {
                new TinyWebServer(Integer.parseInt(args[0]), new File(args[1]));
            }
        }
        catch (BindException x) {
            System.out.println("Can't bind to port :(");
        }
        catch (Exception x) {
            System.out.println("Usage: TinyWebServer [nolist] <port or 'standard'> <base folder>");
        }
    }

    public boolean processResource(String res, boolean head) throws IOException {
        return false;
    }

    public void listDir(File f, String res, boolean mobile, boolean head, String params) throws IOException {
        ((TcpHandler)Thread.currentThread()).listDir(f, res, mobile, head, params);
    }

    public void write(String s) throws IOException {
        ((TcpHandler)Thread.currentThread()).write(s);
    }

    public void writeln(String s) throws IOException {
        ((TcpHandler)Thread.currentThread()).writeln(s);
    }

    public void respondFile(File f, boolean head, boolean byteServing, long rangeBegin, long rangeEnd) throws IOException {
        ((TcpHandler)Thread.currentThread()).respondFile(f, head, byteServing, rangeBegin, rangeEnd);
    }

    public void respondNotFound(byte[] dat, String mime, boolean head) throws IOException {
        ((TcpHandler)Thread.currentThread()).respondNotFound(dat, mime, head);
    }

    public void respondOK(byte[] dat, String mime, boolean head) throws IOException {
        ((TcpHandler)Thread.currentThread()).respondOK(dat, mime, head);
    }

    public void respondRedirect(String location, boolean head) throws IOException {
        ((TcpHandler)Thread.currentThread()).respondRedirect(location, head);
    }

    public void respond(String code, byte[] dat, String mime, boolean head) throws IOException {
        ((TcpHandler)Thread.currentThread()).respond(code, dat, mime, head);
    }

    public void writeChunk(byte[] dat, int len) throws IOException {
        ((TcpHandler)Thread.currentThread()).writeChunk(dat, len);
    }

    public void lastChunk() throws IOException {
        ((TcpHandler)Thread.currentThread()).lastChunk();
    }

    public void respondContinuous(String code, String mime, boolean head) throws IOException {
        ((TcpHandler)Thread.currentThread()).respondContinuous(code, mime, head);
    }

    protected static class MimeTypes {
        private static Object LOCK = new Object();
        private static MimeTypes INSTANCE = new MimeTypes();
        HashMap map = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getMimeTypeFor(String path) {
            int n = path.lastIndexOf(46);
            if (n != -1) {
                path = path.substring(n + 1);
            }
            path = path.toLowerCase();
            Object object = LOCK;
            synchronized (object) {
                return (String)MimeTypes.INSTANCE.map.get(path);
            }
        }

        public MimeTypes() {
            this.map.put("123", "application/vnd.lotus-1-2-3");
            this.map.put("3dm", "x-world/x-3dmf");
            this.map.put("mp4", "video/mp4");
            this.map.put("3dmf", "x-world/x-3dmf");
            this.map.put("3gp", "video/3gp");
            this.map.put("3gpp", "audio/3gp");
            this.map.put("aab", "application/x-authorware-bin");
            this.map.put("aam", "application/x-authorware-map");
            this.map.put("aas", "application/x-authorware-map");
            this.map.put("adr", "application/x-msaddr");
            this.map.put("afl", "video/animaflex");
            this.map.put("ai", "application/postscript");
            this.map.put("aif", "audio/x-aiff");
            this.map.put("aifc", "audio/x-aiff");
            this.map.put("aiff", "audio/x-aiff");
            this.map.put("alt", "application/x-up-alert");
            this.map.put("aos", "application/x-nokia-9000-communicator-add-on-software");
            this.map.put("arj", "application/x-arj");
            this.map.put("asc", "text/plain");
            this.map.put("asd", "application/astound");
            this.map.put("asf", "video/x-ms-asf");
            this.map.put("asn", "application/astound");
            this.map.put("asp", "application/x-asap");
            this.map.put("asx", "video/x-ms-asf");
            this.map.put("asz", "application/astound");
            this.map.put("au", "audio/basic");
            this.map.put("avi", "video/avi");
            this.map.put("axs", "application/olescript");
            this.map.put("bas", "text/plain");
            this.map.put("bat", "text/plain");
            this.map.put("bcpio", "application/x-bcpio");
            this.map.put("bin", "application/octet-stream");
            this.map.put("bmp", "image/bmp");
            this.map.put("cacert", "application/x-x509-ca-cert");
            this.map.put("ccs", "text/ccs");
            this.map.put("cdf", "application/x-netcdf");
            this.map.put("cdr", "application/x-cdr");
            this.map.put("cer", "application/x-x509-ca-cert");
            this.map.put("chat", "application/x-chat");
            this.map.put("che", "application/x-up-cacheop");
            this.map.put("cht", "audio/x-dspeech");
            this.map.put("class", "application/octet-stream");
            this.map.put("clp", "image/x-clp");
            this.map.put("cmd", "text/plain");
            this.map.put("cmx", "image/x-cmx");
            this.map.put("cnc", "application/x-cnc");
            this.map.put("cod", "image/cis-cod");
            this.map.put("coda", "application/x-coda");
            this.map.put("com", "application/octet-stream");
            this.map.put("con", "application/x-connector");
            this.map.put("cpi", "image/cpi");
            this.map.put("cpio", "application/x-cpio");
            this.map.put("csh", "application/x-csh");
            this.map.put("csm", "application/x-cu-seeme");
            this.map.put("css", "text/css");
            this.map.put("csv", "text/comma-separated-values");
            this.map.put("cu", "application/x-cu-seeme");
            this.map.put("cut", "image/x-halo-cut");
            this.map.put("dbf", "application/octet-stream");
            this.map.put("dcr", "application/x-director");
            this.map.put("dig", "multipart/mixed");
            this.map.put("dir", "application/x-director");
            this.map.put("doc", "application/msword");
            this.map.put("dsf", "image/x-mgx-dsf");
            this.map.put("dss", "text/dss");
            this.map.put("dst", "application/tajima");
            this.map.put("dus", "audio/x-dspeech");
            this.map.put("dvi", "application/x-dvi");
            this.map.put("dwf", "drawing/x-dwf");
            this.map.put("dwg", "image/vnd");
            this.map.put("dxf", "image/vnd");
            this.map.put("dxr", "application/x-director");
            this.map.put("ebk", "application/x-expandedbook");
            this.map.put("ecert", "application/x-x509-email-cert");
            this.map.put("email", "application/x-x509-email-cert");
            this.map.put("emf", "image/x-emf");
            this.map.put("eps", "application/postscript");
            this.map.put("erf", "application/x-hsp-erf");
            this.map.put("es", "audio/echospeech");
            this.map.put("etf", "image/x-etf");
            this.map.put("etx", "text/x-setext");
            this.map.put("evy", "application/envoy");
            this.map.put("exe", "application/x-msdownload");
            this.map.put("fh4", "image/x-freehand");
            this.map.put("fh5", "image/x-freehand");
            this.map.put("fhc", "image/x-freehand");
            this.map.put("fif", "image/fif");
            this.map.put("fml", "application/fml");
            this.map.put("fpx", "image/x-fpx");
            this.map.put("frl", "application/freeloader");
            this.map.put("fs", "application/X-FSRecipe");
            this.map.put("gif", "image/gif");
            this.map.put("gsd", "audio/gsm");
            this.map.put("gsm", "audio/gsm");
            this.map.put("gtar", "application/x-gtar");
            this.map.put("gvi", "?");
            this.map.put("gvp", "?");
            this.map.put("gz", "application/gzip");
            this.map.put("hdf", "application/x-hdf");
            this.map.put("hdml", "text/x-hdml");
            this.map.put("hqx", "application/mac-binhex40");
            this.map.put("htm", "text/html");
            this.map.put("html", "text/html");
            this.map.put("ica", "application/x-ica");
            this.map.put("ief", "image/ief");
            this.map.put("ins", "application/x-NET-Install");
            this.map.put("ips", "application/ips");
            this.map.put("ipx", "application/x-ipix");
            this.map.put("ivr", "i-world/i-vrml");
            this.map.put("jad", "text/vnd.sun.j2me.app-descriptor");
            this.map.put("jar", "application/java-archive");
            this.map.put("jar.pack.gz", "application/x-java-pack200");
            this.map.put("jardiff", "application/x-java-archive-diff");
            this.map.put("java", "text/x-java-source");
            this.map.put("jnlp", "application/x-java-jnlp-file");
            this.map.put("jp2", "image/jp2");
            this.map.put("jpe", "image/jpeg");
            this.map.put("jpeg", "image/jpeg");
            this.map.put("jpg", "image/jpeg");
            this.map.put("jps", "image/x-jps");
            this.map.put("js", "application/x-javascript");
            this.map.put("latex", "application/x-latex");
            this.map.put("lha", "application/octet-stream");
            this.map.put("lit", "application/lit");
            this.map.put("lsp", "text/lsp");
            this.map.put("lwp", "application/x-wordpro");
            this.map.put("lzh", "application/octet-stream");
            this.map.put("lzx", "application/octet-stream");
            this.map.put("m3u", "audio/x-mpegurl");
            this.map.put("man", "application/x-troff-man");
            this.map.put("map", "application/x-httpd-imap");
            this.map.put("mbd", "application/mbedlet");
            this.map.put("mcf", "image/vasa");
            this.map.put("mdb", "application/mdb");
            this.map.put("me", "application/x-troff-me");
            this.map.put("mfp", "application/mirage");
            this.map.put("mid", "audio/x-midi");
            this.map.put("midi", "audio/x-midi");
            this.map.put("mif", "application/x-mif");
            this.map.put("mol", "chemical/x-mdl-molfile");
            this.map.put("mov", "video/quicktime");
            this.map.put("movie", "video/x-sgi-movie");
            this.map.put("mp2", "audio/x-mpeg");
            this.map.put("mp3", "audio/mpeg");
            this.map.put("mpe", "video/mpeg");
            this.map.put("mpeg", "video/mpeg");
            this.map.put("mpg", "video/mpeg");
            this.map.put("mpire", "application/x-mpire");
            this.map.put("mpl", "application/x-mpire");
            this.map.put("mpp", "application/vnd.ms-project");
            this.map.put("ms", "application/x-troff-ms");
            this.map.put("msi", "application/msi");
            this.map.put("msm", "application/msm");
            this.map.put("n2p", "application/n2p");
            this.map.put("nc", "application/x-netcdf");
            this.map.put("npx", "application/x-netfpx");
            this.map.put("nsc", "application/x-nschat");
            this.map.put("oda", "application/oda");
            this.map.put("ofml", "application/fml");
            this.map.put("page", "application/x-coda");
            this.map.put("pbd", "application/vnd.powerbuilder6");
            this.map.put("pbm", "image/x-portable-bitmap");
            this.map.put("pdb", "chemical/x-pdb");
            this.map.put("pdf", "application/pdf");
            this.map.put("pfr", "application/font-tdpfr");
            this.map.put("pgm", "image/x-portable-graymap");
            this.map.put("pgp", "application/x-pgp-plugin");
            this.map.put("pgr", "text/parsnegar-document");
            this.map.put("php", "application/x-httpd-php");
            this.map.put("php3", "application/x-httpd-php3");
            this.map.put("php4", "application/x-httpd-php");
            this.map.put("pls", "application/pls");
            this.map.put("png", "image/png");
            this.map.put("pnm", "image/x-portable-anymap");
            this.map.put("pot", "application/mspowerpoint");
            this.map.put("ppm", "image/x-portable-pixmap");
            this.map.put("pps", "application/mspowerpoint");
            this.map.put("ppt", "application/mspowerpoint");
            this.map.put("ppz", "application/mspowerpoint");
            this.map.put("pqf", "application/x-cprplayer");
            this.map.put("pqi", "application/cprplayer");
            this.map.put("properties", "text/plain");
            this.map.put("ps", "application/postscript");
            this.map.put("psr", "application/datawindow");
            this.map.put("ptlk", "application/listenup");
            this.map.put("push", "multipart/x-mixed-replace");
            this.map.put("qd3", "x-world/x-3dmf");
            this.map.put("qd3d", "x-world/x-3dmf");
            this.map.put("qrt", "application/quest");
            this.map.put("qt", "video/quicktime");
            this.map.put("qti", "image/x-quicktime");
            this.map.put("qtl", "application/x-quicktimeplayer");
            this.map.put("ra", "audio/x-pn-realaudio");
            this.map.put("ram", "audio/x-pn-realaudio");
            this.map.put("ras", "image/x-cmu-raster");
            this.map.put("rgb", "image/x-rgb");
            this.map.put("rgb", "image/x-rgb");
            this.map.put("rip", "image/rip");
            this.map.put("rm", "audio/x-pn-realaudio");
            this.map.put("rmf", "audio/rmf");
            this.map.put("rng", "application/ringing-tones");
            this.map.put("roff", "application/x-troff");
            this.map.put("rpm", "audio/x-pn-realaudio-plugin");
            this.map.put("rrf", "application/x-InstallFromTheWeb");
            this.map.put("rss", "application/rss+xml");
            this.map.put("rtc", "application/rtc");
            this.map.put("rtf", "application/rtf");
            this.map.put("rtx", "text/richtext");
            this.map.put("sca", "application/x-supercard");
            this.map.put("scert", "application/x-x509-server-cert");
            this.map.put("scr", "application/octet-stream");
            this.map.put("seq", "application/octet-stream-bin");
            this.map.put("ser", "application/x-java-serialized-object");
            this.map.put("sh", "application/x-sh");
            this.map.put("shar", "application/x-shar");
            this.map.put("shtml", "text/x-server-parsed-html");
            this.map.put("shw", "application/presentations");
            this.map.put("sit", "application/x-stuffit");
            this.map.put("sjf", "application/octet-stream");
            this.map.put("smi", "application/smil");
            this.map.put("smil", "application/smil");
            this.map.put("sml", "application/smil");
            this.map.put("smp", "application/studiom");
            this.map.put("snd", "audio/basic");
            this.map.put("spc", "text/x-speech");
            this.map.put("spl", "application/futuresplash");
            this.map.put("spr", "application/x-sprite");
            this.map.put("sprite", "application/x-sprite");
            this.map.put("sql", "text/plain");
            this.map.put("src", "application/x-wais-source");
            this.map.put("ssi", "text/x-server-parsed-html");
            this.map.put("stk", "application/hstu");
            this.map.put("stream", "audio/x-qt-stream");
            this.map.put("sv4cpio", "application/x-sv4cpio");
            this.map.put("sv4crc", "application/x-sv4crc");
            this.map.put("svf", "image/vnd");
            this.map.put("svh", "image/svh");
            this.map.put("svr", "x-world/x-svr");
            this.map.put("swa", "application/x-director");
            this.map.put("swf", "application/x-shockwave-flash");
            this.map.put("t", "application/x-troff");
            this.map.put("talk", "application/talker");
            this.map.put("tar", "application/x-tar");
            this.map.put("tbk", "application/toolbook");
            this.map.put("tcl", "application/x-tcl");
            this.map.put("tex", "application/x-tex");
            this.map.put("texi", "application/x-texinfo");
            this.map.put("texinfo", "application/x-texinfo");
            this.map.put("text", "text/plain");
            this.map.put("tgz", "application/gzip");
            this.map.put("tif", "image/tiff");
            this.map.put("tiff", "image/tiff");
            this.map.put("tlk", "application/x-tlk");
            this.map.put("tmv", "application/x-Parable-Thing");
            this.map.put("torrent", "application/x-bittorrent");
            this.map.put("tr", "application/x-troff");
            this.map.put("troff", "application/x-troff");
            this.map.put("tsi", "audio/tsplayer");
            this.map.put("tsp", "application/dsptype");
            this.map.put("tsq", "application/timestamp-query");
            this.map.put("tsr", "application/timestamp-reply");
            this.map.put("tsv", "text/tab-separated-values");
            this.map.put("txt", "text/plain");
            this.map.put("u98", "urdu/urdu98");
            this.map.put("ucert", "application/x-x509-user-cert");
            this.map.put("uin", "application/x-icq");
            this.map.put("usercert", "application/x-x509-user-cert");
            this.map.put("usr", "application/x-x509-user-cert");
            this.map.put("ustar", "application/x-ustar");
            this.map.put("vbd", "application/activexdocument");
            this.map.put("vcd", "application/x-cdlink");
            this.map.put("vcf", "text/x-vcard");
            this.map.put("vew", "application/groupwise");
            this.map.put("vgm", "video/x-videogram");
            this.map.put("vgp", "video/x-videogram-plugin");
            this.map.put("vgx", "video/x-videogram");
            this.map.put("viv", "video/vnd.vivo");
            this.map.put("vivo", "video/vnd.vivo");
            this.map.put("vmd", "application/vocaltec-media-desc");
            this.map.put("vmf", "application/vocaltec-media-file");
            this.map.put("vmi", "application/x-dreamcast-vms-info");
            this.map.put("vms", "application/x-dreamcast-vms");
            this.map.put("vox", "audio/voxware");
            this.map.put("vpa", "application/vpa");
            this.map.put("vqe", "audio/x-twinvq-plugin");
            this.map.put("vqf", "audio/x-twinvq");
            this.map.put("vql", "audio/x-twinvq");
            this.map.put("vrt", "x-world/x-vrt");
            this.map.put("vts", "workbook/formulaone");
            this.map.put("vtts", "workbook/formulaone");
            this.map.put("w60", "application/wordperfect6.0");
            this.map.put("w61", "application/wordperfect6.1");
            this.map.put("waf", "plugin/wanimate");
            this.map.put("wan", "plugin/wanimate");
            this.map.put("wav", "audio/wav");
            this.map.put("wax", "audio/x-ms-wax");
            this.map.put("wbmp", "image/vnd.wap.wbmp");
            this.map.put("wi", "image/wavelet");
            this.map.put("wid", "application/x-DemoShield");
            this.map.put("wis", "application/x-InstallShield");
            this.map.put("wlt", "application/x-mswallet");
            this.map.put("wm", "video/x-ms-wm");
            this.map.put("wma", "audio/x-ms-wma");
            this.map.put("wmd", "application/x-ms-wmd");
            this.map.put("wmf", "image/x-wmf");
            this.map.put("wml", "x-world/x-vrml");
            this.map.put("wmlc", "application/vnd.wap.wmlc");
            this.map.put("wmls", "text/vnd.wap.wmlscript");
            this.map.put("wmlsc", "application/vnd.wap.wmlscriptc");
            this.map.put("wmv", "video/x-ms-wmv");
            this.map.put("wmx", "video/x-ms-wmx");
            this.map.put("wmz", "application/x-ms-wmz");
            this.map.put("wp", "application/wordperfect");
            this.map.put("wp5", "application/wordperfect");
            this.map.put("wpd", "application/wordperfect5.1");
            this.map.put("wri", "application/write");
            this.map.put("wrl", "x-world/x-vrml");
            this.map.put("wrz", "x-world/x-vrml");
            this.map.put("wtx", "audio/wtx");
            this.map.put("wvx", "video/x-ms-wvx");
            this.map.put("xbm", "image/x-xbitmap");
            this.map.put("xdr", "video/x-videogram");
            this.map.put("xif", "image/vnd.xiff");
            this.map.put("xla", "application/vnd.ms-excel");
            this.map.put("xlc", "application/vnd.ms-excel");
            this.map.put("xlm", "application/vnd.ms-excel");
            this.map.put("xls", "application/vnd.ms-excel");
            this.map.put("xlt", "application/vnd.ms-excel");
            this.map.put("xlw", "application/vnd.ms-excel");
            this.map.put("xml", "application/xml");
            this.map.put("xpm", "image/x-xpixmap");
            this.map.put("xwd", "image/x-xwindowdump");
            this.map.put("z", "application/x-compress");
            this.map.put("zip", "application/x-zip-compressed");
            this.map.put("zpa", "application/pcphoto");
        }
    }

    public class TcpHandler
    extends Thread {
        Socket sock;
        InputStream in;
        OutputStream out;

        public TcpHandler(Socket sock) throws IOException {
            this.sock = sock;
            this.in = new BufferedInputStream(sock.getInputStream(), 4096);
            this.out = new BufferedOutputStream(sock.getOutputStream(), 4096);
        }

        void writeChunk(byte[] dat, int len) throws IOException {
            this.writeln("" + Integer.toHexString(len));
            this.out.write(dat, 0, len);
            this.writeln("");
            this.out.flush();
        }

        void lastChunk() throws IOException {
            this.writeln("0");
            this.writeln("");
            this.writeln("");
            this.out.flush();
        }

        void write(String s) throws IOException {
            this.out.write(s.getBytes("ASCII"));
        }

        void writeln(String s) throws IOException {
            this.out.write(s.getBytes("ASCII"));
            this.out.write(13);
            this.out.write(10);
        }

        void respondFile(File f, boolean head, boolean byteServing, long rangeBegin, long rangeEnd) throws IOException {
            long flen = f.length();
            if (rangeEnd == -1L) {
                rangeEnd = flen - 1L;
            }
            long rangeLen = rangeEnd - rangeBegin + 1L;
            if (byteServing) {
                this.writeln("HTTP/1.1 206 Partial content");
                this.writeln("Content-Range: bytes " + rangeBegin + "-" + rangeEnd + "/" + flen);
            } else {
                this.writeln("HTTP/1.1 200 OK");
            }
            if (!TinyWebServer.this.allowCaching()) {
                this.writeln("Cache-Control: no-cache");
            }
            if (!TinyWebServer.this.allowCaching()) {
                this.writeln("Pragma: no-cache");
            }
            this.writeln("Accept-Ranges: bytes");
            this.writeln("Content-Type: " + MimeTypes.getMimeTypeFor(f.getName()));
            if (!head) {
                this.writeln("Content-Length: " + rangeLen);
            } else {
                this.writeln("Content-Length: 0");
            }
            this.writeln("");
            if (!head) {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(f, "r");
                    raf.seek(rangeBegin);
                    long rem = rangeLen;
                    byte[] buf = new byte[50000];
                    int n = 0;
                    while (n != -1 && rem > 0L) {
                        n = raf.read(buf, 0, (int)Math.min((long)buf.length, rem));
                        if (n <= 0) continue;
                        this.out.write(buf, 0, n);
                        rem -= (long)n;
                    }
                    raf.close();
                }
                catch (IOException x) {
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException xx) {
                        throw x;
                    }
                }
            }
            this.out.flush();
        }

        void respondNotFound(byte[] dat, String mime, boolean head) throws IOException {
            if (DEBUG404) {
                new FileNotFoundException("TWS 404").printStackTrace();
            }
            this.respond("404 Not Found", dat, mime, head);
        }

        void respondOK(byte[] dat, String mime, boolean head) throws IOException {
            this.respond("200 OK", dat, mime, head);
        }

        void respondRedirect(String location, boolean head) throws IOException {
            this.respond("302 Found", new byte[0], null, head, new String[]{"Location: " + location});
        }

        void respond(String code, byte[] dat, String mime, boolean head) throws IOException {
            this.respond(code, dat, mime, head, new String[0]);
        }

        void respond(String code, byte[] dat, String mime, boolean head, String[] headers) throws IOException {
            this.writeln("HTTP/1.1 " + code);
            if (!TinyWebServer.this.allowCaching()) {
                this.writeln("Cache-Control: no-cache");
            }
            if (!TinyWebServer.this.allowCaching()) {
                this.writeln("Pragma: no-cache");
            }
            for (int i = 0; i < headers.length; ++i) {
                this.writeln(headers[i]);
            }
            if (mime != null) {
                this.writeln("Content-Type: " + mime);
            }
            if (!head && dat != null) {
                this.writeln("Content-Length: " + dat.length);
            } else {
                this.writeln("Content-Length: 0");
            }
            this.writeln("");
            if (!head && dat != null) {
                this.out.write(dat);
            }
            this.out.flush();
        }

        void listDir(File file, String res, boolean mobile, boolean head, String params) throws IOException {
            int i;
            StringBuffer sb = new StringBuffer();
            if (mobile) {
                sb.append("<html><body style='font-family:sans-serif; font-size: 150%'>");
                sb.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
                sb.append("<h1 style='font-size: 125%'>Listing '").append(file.getName()).append("'</h1><br>");
            } else {
                sb.append("<html><body style='font-family:sans-serif'>");
                sb.append("<h1>Listing '").append(file.getName()).append("'</h1><br>");
            }
            Object[] list = file.list();
            Arrays.sort(list);
            for (i = 0; i < list.length; ++i) {
                if (((String)list[i]).startsWith(".") && !TinyWebServer.this.listDotFiles) continue;
                String mime = MimeTypes.getMimeTypeFor((String)list[i]);
                boolean isImage = false;
                if (mime != null) {
                    isImage = mime.toLowerCase().startsWith("image");
                }
                if (isImage) {
                    if (res.length() > 0) {
                        sb.append("<a href='/").append(res).append("/").append((String)list[i]).append("'>");
                        sb.append("<img border='0' width='300' src='/").append(res).append("/").append((String)list[i]).append("'>");
                    } else {
                        sb.append("<a href='/").append((String)list[i]).append("'>");
                        sb.append("<img border='0' width='300' src='/").append((String)list[i]).append("'>");
                    }
                    sb.append("</a><br>");
                    continue;
                }
                if (!mobile) {
                    if (res.length() > 0) {
                        sb.append("<a href='/").append(res).append("/").append((String)list[i] + ".zip").append("?zip'>");
                    } else {
                        sb.append("<a href='/").append((String)list[i] + ".zip").append("?zip'>");
                    }
                    sb.append("[zip]");
                    sb.append("</a> - ");
                }
                if (res.length() > 0) {
                    sb.append("<a href='/").append(res).append("/").append((String)list[i]).append("'>");
                } else {
                    sb.append("<a href='/").append((String)list[i]).append("'>");
                }
                sb.append((String)list[i]);
                sb.append("</a><br>");
            }
            if (mobile) {
                for (i = 0; i < 10; ++i) {
                    sb.append("<br>");
                }
            }
            sb.append("</body></html>");
            this.respondOK(sb.toString().getBytes("ASCII"), "text/html", head);
        }

        void respondContinuous(String code, String mime, boolean head) throws IOException {
            this.writeln("HTTP/1.1 " + code);
            if (!TinyWebServer.this.allowCaching()) {
                this.writeln("Cache-Control: no-cache");
            }
            if (!TinyWebServer.this.allowCaching()) {
                this.writeln("Pragma: no-cache");
            }
            this.writeln("Content-Type: " + mime);
            this.writeln("Transfer-Encoding: chunked");
            this.writeln("");
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean loop = true;
            while (loop) {
                try {
                    String s = StreamUtils.readLineAsStringUTF8(this.in);
                    System.out.println("[TinyWebServerRequest] " + s);
                    while (s.trim().length() == 0) {
                        s = StreamUtils.readLineAsStringUTF8(this.in);
                    }
                    if (s == null) {
                        loop = false;
                        System.out.println("[TinyWebServer] connection closed gracefully");
                        continue;
                    }
                    String slc = s.toLowerCase();
                    if (slc.startsWith("get") || slc.startsWith("head")) {
                        String header;
                        int chop;
                        String res;
                        boolean head = slc.startsWith("head");
                        if (slc.endsWith("1.0")) {
                            loop = false;
                            System.out.println("[TinyWebServer] connection will close after response (HTTP/1.0)");
                        }
                        if ((res = s.substring(4, chop = slc.lastIndexOf("http")).trim()).charAt(0) == '/') {
                            res = res.substring(1);
                        }
                        res = res.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                        boolean byteServing = false;
                        boolean mobileClient = false;
                        long rangeBegin = 0L;
                        long rangeEnd = -1L;
                        while ((header = StreamUtils.readLineAsStringUTF8(this.in).trim()).length() > 0) {
                            String lchead;
                            if (DEBUG) {
                                System.out.println("[TinyWebServerRequest] " + header);
                            }
                            if ((lchead = header.toLowerCase()).startsWith("connection") && lchead.indexOf("close") != -1) {
                                loop = false;
                                System.out.println("[TinyWebServer] connection will close after response (Connection: close)");
                            }
                            if (lchead.startsWith("range:")) {
                                byteServing = true;
                                String range = lchead.substring(lchead.indexOf("bytes") + 5);
                                range = range.substring(range.indexOf(61) + 1);
                                range = range.trim();
                                int index = range.indexOf(45);
                                String begin = range.substring(0, index);
                                String end = range.substring(index + 1);
                                try {
                                    rangeBegin = Long.parseLong(begin);
                                    if (end.length() > 0) {
                                        rangeEnd = Long.parseLong(end);
                                    }
                                }
                                catch (Exception x) {
                                    x.printStackTrace();
                                }
                            }
                            if (!lchead.startsWith("user-agent:") || lchead.indexOf("iphone") == -1) continue;
                            mobileClient = true;
                        }
                        HandlerResponse handlerresp = null;
                        if (TinyWebServer.this.reshandler != null) {
                            Properties props = new Properties();
                            int qmark = res.indexOf(63);
                            if (qmark != -1) {
                                String[] queries;
                                String query = res.substring(qmark + 1);
                                res = res.substring(0, qmark);
                                for (String pair : queries = query.split("&")) {
                                    String val;
                                    String key;
                                    int eqmark = pair.indexOf(61);
                                    if (eqmark != -1) {
                                        key = pair.substring(0, eqmark);
                                        val = pair.substring(eqmark + 1);
                                    } else {
                                        key = pair;
                                        val = "";
                                    }
                                    props.setProperty(URLDecoder.decode(key), URLDecoder.decode(val));
                                }
                                res = URLDecoder.decode(res);
                            }
                            handlerresp = TinyWebServer.this.reshandler.getResponseFor(res, props);
                        }
                        if (handlerresp != null) {
                            this.respondOK(handlerresp.dat, handlerresp.mime, head);
                            continue;
                        }
                        if (!TinyWebServer.this.useResourceHandlerOnly) {
                            String origres = res = URLDecoder.decode(res);
                            boolean returnAsZip = false;
                            String params = "";
                            int index = res.indexOf(63);
                            if (index != -1) {
                                params = res.substring(index + 1);
                                res = res.substring(0, index);
                                if (params.indexOf("zip") != -1) {
                                    returnAsZip = true;
                                }
                            }
                            if (TinyWebServer.this.processResource(origres, head)) continue;
                            if (res.length() < 2 && TinyWebServer.this.slashRedirect != null) {
                                this.respondRedirect(TinyWebServer.this.slashRedirect, head);
                                continue;
                            }
                            File file = new File(TinyWebServer.this.base, res);
                            if (returnAsZip) {
                                file = new File(TinyWebServer.this.base, res.substring(0, res.length() - 4));
                                System.out.println("[TinyWebServer] Serving " + file + " as ZIP");
                                this.respondOK(TinyWebServer.zipUp(file).toByteArray(), "application/zip", head);
                                continue;
                            }
                            if (file.exists()) {
                                System.out.println("[TinyWebServer] Serving " + file + " as " + MimeTypes.getMimeTypeFor(file.getName()));
                                if (!file.isDirectory()) {
                                    this.respondFile(file, head, byteServing, rangeBegin, rangeEnd);
                                    continue;
                                }
                                if (TinyWebServer.this.listDirs) {
                                    TinyWebServer.this.listDir(file, res, mobileClient, head, params);
                                    continue;
                                }
                                this.respondNotFound("TinyWebServer: Error 404, file not found".getBytes("ASCII"), "text/plain", head);
                                continue;
                            }
                            System.out.println("[TinyWebServer] File Not Found " + file);
                            this.respondNotFound("TinyWebServer: Error 404, file not found".getBytes("ASCII"), "text/plain", head);
                            continue;
                        }
                        this.respondNotFound("TinyWebServer: Error 404, file not found".getBytes("ASCII"), "text/plain", head);
                        continue;
                    }
                    if (!slc.startsWith("post")) continue;
                    System.out.println("[TinyWebServer] POST not implemented");
                }
                catch (EOFException x) {
                    System.out.println("[TinyWebServer] session closed");
                }
                catch (Throwable t) {
                    System.out.println("[TinyWebServer] ERROR in transaction");
                    t.printStackTrace(System.out);
                }
                finally {
                    try {
                        this.sock.close();
                    }
                    catch (IOException x) {}
                    loop = false;
                }
            }
        }
    }

    public static interface ResourceHandler {
        public HandlerResponse getResponseFor(String var1, Properties var2);
    }

    public static class HandlerResponse {
        byte[] dat;
        String mime = "text/html";

        public HandlerResponse(byte[] dat) {
            this.dat = dat;
        }

        public HandlerResponse(byte[] dat, String mime) {
            this.dat = dat;
            this.mime = mime;
        }
    }

    class TcpServer
    extends Thread {
        ServerSocket ssock;

        public TcpServer(int port, boolean SSL) throws IOException {
            this.ssock = SSL ? SSLServerSocketFactory.getDefault().createServerSocket(port) : new ServerSocket(port);
        }

        @Override
        public void run() {
            try {
                System.out.println("[TinyWebServer] Ready");
                while (true) {
                    Socket sock = this.ssock.accept();
                    new TcpHandler(sock).start();
                }
            }
            catch (Throwable t) {
                TinyWebServer.this.shutdown();
                return;
            }
        }
    }
}

