/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class StreamPiper {
    public static void pipe(InputStream in, OutputStream out, boolean flushAtEndOfData, boolean flushOnEveryWrite, boolean flushOnReadTimeout) throws IOException {
        StreamPiper.pipe(in, out, 50000, null, flushAtEndOfData, flushOnEveryWrite, flushOnReadTimeout);
    }

    public static void pipe(InputStream in, OutputStream out, int bufSize, boolean flushAtEndOfData, boolean flushOnEveryWrite, boolean flushOnReadTimeout) throws IOException {
        StreamPiper.pipe(in, out, bufSize, null, flushAtEndOfData, flushOnEveryWrite, flushOnReadTimeout);
    }

    public static void pipe(InputStream in, OutputStream out, int bufSize, StreamStatusListener listener, boolean flushAtEndOfData, boolean flushOnEveryWrite, boolean flushOnReadTimeout) throws IOException {
        int n = 0;
        byte[] buf = new byte[bufSize];
        while (n != -1) {
            try {
                n = in.read(buf, 0, bufSize);
                if (n <= 0) continue;
                out.write(buf, 0, n);
                if (!flushOnEveryWrite) continue;
                out.flush();
            }
            catch (InterruptedIOException x) {
                if (!flushOnReadTimeout) continue;
                if (x.bytesTransferred > 0) {
                    out.write(buf, 0, x.bytesTransferred);
                }
                out.flush();
            }
        }
        if (flushAtEndOfData) {
            out.flush();
        }
        if (listener != null) {
            listener.sourceStreamIsClosed();
        }
    }

    public static Thread pipeAsync(InputStream in, OutputStream out) throws IOException {
        AsyncPipe t = new AsyncPipe(in, out, 50000, null, false, false, false);
        t.start();
        return t;
    }

    public static Thread pipeAsync(InputStream in, OutputStream out, int bufSize) throws IOException {
        AsyncPipe t = new AsyncPipe(in, out, bufSize, null, false, false, false);
        t.start();
        return t;
    }

    public static Thread pipeAsync(InputStream in, OutputStream out, int bufSize, StreamStatusListener listener, boolean flushAtEndOfData, boolean flushOnEveryWrite, boolean flushOnReadTimeout) throws IOException {
        AsyncPipe t = new AsyncPipe(in, out, bufSize, listener, flushAtEndOfData, flushOnEveryWrite, flushOnReadTimeout);
        t.start();
        return t;
    }

    public static interface StreamStatusListener {
        public void sourceStreamIsClosed();
    }

    private static class AsyncPipe
    extends Thread {
        InputStream in;
        OutputStream out;
        private int bufSize;
        private StreamStatusListener listener;
        boolean flushAtEndOfData;
        boolean flushOnEveryWrite;
        boolean flushOnReadTimeout;

        AsyncPipe(InputStream in, OutputStream out, int bufSize, StreamStatusListener listener, boolean flushAtEndOfData, boolean flushOnEveryWrite, boolean flushOnReadTimeout) {
            super("AsyncPipe");
            this.in = in;
            this.out = out;
            this.bufSize = bufSize;
            this.listener = listener;
            this.flushAtEndOfData = flushAtEndOfData;
            this.flushOnEveryWrite = flushOnEveryWrite;
            this.flushOnReadTimeout = flushOnReadTimeout;
        }

        @Override
        public void run() {
            try {
                StreamPiper.pipe(this.in, this.out, this.bufSize, this.listener, this.flushAtEndOfData, this.flushOnEveryWrite, this.flushOnReadTimeout);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

