/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Properties;
import utils.stream.CFriendlyStreamUtils;
import utils.stream.StreamParameteriser;

public class GenericParameteriser {
    static boolean VERBOSE_VERIFY = false;
    public static final byte[] defStart = new byte[]{127, -16, -126, -54, 76, 117, -81, 21, 55, -61, -41, 24, -2, -121, 53, 42, -117, -95, -25, -106, 35, -50, 93, -113, -120, 44, -84, -66, -113, -22, -93, 59, -11, -100, 7, -106, -106, -14, -30, 69, -42, -26, -83, 119, 101, 5, -98, 44, 5, 83, 1, -58, 117, 47, 71, -49, -44, -25, 116, 53, -9, 61, 19, 109};
    public static final byte[] defEnd = new byte[]{109, 19, 61, -9, 53, 116, -25, -44, -49, 71, 47, 117, -58, 1, 83, 5, 44, -98, 5, 101, 119, -83, -26, -42, 69, -30, -14, -106, -106, 7, -100, -11, 59, -93, -22, -113, -66, -84, 44, -120, -113, 93, -50, 35, -106, -25, -95, -117, 42, 53, -121, -2, 24, -41, -61, 55, 21, -81, 117, 76, -54, -126, -16, 127};

    public byte[] getStartMarker() {
        return defStart;
    }

    public byte[] getEndMarker() {
        return defEnd;
    }

    public byte[] getUnparameterisedBlock(int spaceNotIncludingMarkers) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(this.getStartMarker());
        for (int i = 0; i < spaceNotIncludingMarkers; ++i) {
            bout.write(0);
        }
        bout.write(this.getEndMarker());
        return bout.toByteArray();
    }

    private int findIndexBefore(byte[] mark, File file) throws IOException {
        int index = this.findIndexAfter(mark, file);
        if (index == -1) {
            return -1;
        }
        return index - mark.length;
    }

    private int findIndexAfter(byte[] mark, File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        int index = 0;
        int pos = 0;
        int n = ((InputStream)in).read();
        while (pos < mark.length && n != -1) {
            byte c = mark[pos];
            if (n > 128) {
                n -= 256;
            }
            pos = c == n ? ++pos : 0;
            n = ((InputStream)in).read();
            ++index;
        }
        System.out.println("n=" + n + ", pos=" + pos + ", mark=" + mark.length);
        if (pos == mark.length) {
            ((InputStream)in).close();
            return index;
        }
        ((InputStream)in).close();
        return -1;
    }

    public boolean validateCLength(File file) throws IOException {
        int start = this.findIndexAfter(this.getStartMarker(), file);
        int end = this.findIndexBefore(this.getEndMarker(), file);
        if (start == -1) {
            System.out.println("Unparameterised start not found");
            return false;
        }
        if (end == -1) {
            System.out.println("Unparameterised end not found");
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.seek(start);
        System.out.println("Params at " + start);
        int len = end - start;
        System.out.println("Param block length is " + len);
        boolean OK = true;
        int oldn = 32;
        for (int i = 0; i < len; ++i) {
            int n = raf.read();
            if (oldn == 0 && n == 0) {
                System.out.println("Valid params length (as seen by C code) is " + i);
                break;
            }
            oldn = n;
        }
        raf.close();
        return OK;
    }

    public boolean validateUnparameterised(File file) throws IOException {
        int start = this.findIndexAfter(this.getStartMarker(), file);
        int end = this.findIndexBefore(this.getEndMarker(), file);
        if (start == -1) {
            System.out.println("[GenericParameteriser] Unparameterised start not found");
            return false;
        }
        if (end == -1) {
            System.out.println("[GenericParameteriser] Unparameterised end not found");
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.seek(start);
        System.out.println("[GenericParameteriser] Params at " + start);
        int len = end - start;
        boolean OK = true;
        for (int i = 0; i < len; ++i) {
            int n = raf.read();
            if (n == 0) continue;
            System.out.println("[GenericParameteriser] " + n + " at " + i);
            OK = false;
            break;
        }
        raf.close();
        return OK;
    }

    public byte[] getParameterisedBlock(Properties props, int padToNotIncludingMarkers) throws Exception {
        Object[] keys = props.keySet().toArray();
        String[] names = new String[keys.length];
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            names[i] = "" + keys[i];
            values[i] = props.getProperty(names[i]);
        }
        return this.getParameterisedBlock(names, values, padToNotIncludingMarkers);
    }

    public byte[] getParameterisedBlock(String[] names, String[] values, int padToNotIncludingMarkers) throws Exception {
        if (names.length != values.length) {
            throw new Exception("Names and values do not match (different sizes)");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(this.getStartMarker());
        CFriendlyStreamUtils.writeInt(bout, names.length);
        for (int i = 0; i < names.length; ++i) {
            CFriendlyStreamUtils.writeString(bout, names[i]);
            CFriendlyStreamUtils.writeString(bout, values[i]);
        }
        byte[] startMarker = this.getStartMarker();
        while (bout.size() < startMarker.length + padToNotIncludingMarkers) {
            bout.write(0);
        }
        bout.write(this.getEndMarker());
        return bout.toByteArray();
    }

    public void setParameters(Properties props, File file, boolean overwrite) throws IOException {
        Object[] keys = props.keySet().toArray();
        String[] names = new String[keys.length];
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            names[i] = "" + keys[i];
            values[i] = props.getProperty(names[i]);
        }
        this.setParameters(names, values, file, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(String[] names, String[] values, File file, boolean overwrite) throws IOException {
        if (names.length != values.length) {
            throw new IOException("Names and values do not match (different sizes)");
        }
        if (!overwrite && !this.validateUnparameterised(file)) {
            throw new IOException("Untainted parameter area not found in file " + file.getName());
        }
        int start = this.findIndexAfter(this.getStartMarker(), file);
        ByteArrayOutputStream prep = new ByteArrayOutputStream();
        CFriendlyStreamUtils.writeInt(prep, names.length);
        for (int i = 0; i < names.length; ++i) {
            CFriendlyStreamUtils.writeString(prep, names[i]);
            CFriendlyStreamUtils.writeString(prep, values[i]);
        }
        byte[] block = prep.toByteArray();
        if (VERBOSE_VERIFY) {
            System.out.println("[GenericParaemeteriser] Readied parameter block len=" + block.length);
        }
        prep = null;
        RandomAccessFile raf = new RandomAccessFile(file, "rwd");
        try {
            int attempt = 1;
            boolean verified = false;
            while (!verified) {
                raf.seek(start);
                raf.write(block, 0, block.length);
                if (VERBOSE_VERIFY) {
                    System.out.println("[GenericParaemeteriser] Wrote parameter block len=" + block.length);
                }
                raf.seek(start);
                byte[] compare = new byte[block.length];
                int n = 0;
                int tot = 0;
                while (tot < compare.length && n != -1) {
                    n = raf.read(compare, tot, compare.length - tot);
                    if (n <= 0) continue;
                    tot += n;
                }
                if (VERBOSE_VERIFY) {
                    System.out.println("[GenericParaemeteriser] Read back parameter block for verification len=" + compare.length);
                }
                if (Arrays.equals(block, compare)) {
                    if (VERBOSE_VERIFY) {
                        System.out.println("[GenericParaemeteriser] Parameter block written and verified OK");
                    }
                    verified = true;
                    continue;
                }
                if (attempt == 8) {
                    throw new IOException("Failed to write parameters, unable to verify (consistently collided)");
                }
                try {
                    System.out.println("[GenericParameteriser] Collision writing parameters, will back off and retry");
                    Thread.sleep((int)(Math.random() * 350.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++attempt;
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public StreamParameteriser newStreamParametiser(Properties props) throws IOException {
        Object[] keys = props.keySet().toArray();
        String[] names = new String[keys.length];
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            names[i] = "" + keys[i];
            values[i] = props.getProperty(names[i]);
        }
        return this.newStreamParametiser(names, values);
    }

    public StreamParameteriser newStreamParametiser(String[] names, String[] values) throws IOException {
        if (names.length != values.length) {
            throw new IOException("Names and values do not match (different sizes)");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CFriendlyStreamUtils.writeInt(bout, names.length);
        for (int i = 0; i < names.length; ++i) {
            CFriendlyStreamUtils.writeString(bout, names[i]);
            CFriendlyStreamUtils.writeString(bout, values[i]);
        }
        byte[] payload = bout.toByteArray();
        bout = null;
        return new StreamParameteriser(this.getStartMarker(), payload);
    }

    public Properties getParameters(File file) throws IOException {
        int start = this.findIndexAfter(this.getStartMarker(), file);
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.seek(start);
        Properties props = new Properties();
        int num = CFriendlyStreamUtils.readInt(raf);
        for (int i = 0; i < num; ++i) {
            String name = CFriendlyStreamUtils.readString(raf);
            String value = CFriendlyStreamUtils.readString(raf);
            if (name != null && value != null && value.length() > 200) {
                System.out.println("[GenericParameteriser] " + name + "=" + value.substring(0, 200) + "... [" + value.length() + "]");
            } else {
                System.out.println("[GenericParameteriser] " + name + "=" + value + " [" + value.length() + "]");
            }
            props.setProperty(name, value);
        }
        System.out.println("[GenericParameteriser] Total valid parameters length is " + (raf.getFilePointer() - (long)start));
        return props;
    }

    public static void main(String[] args) throws Exception {
        GenericParameteriser gp = new GenericParameteriser();
        File file = new File("params.txt");
        FileOutputStream f = new FileOutputStream(file);
        f.write(gp.getUnparameterisedBlock(500));
        f.close();
        String[] names = new String[]{"nameOne", "nameTwo", "name\n\tThree"};
        String[] values = new String[]{"123456", "!@$%^", "bit of text"};
        gp.setParameters(names, values, file, false);
        Properties props = new Properties();
        for (int i = 1; i < 20; ++i) {
            props.setProperty(GenericParameteriser.genString(i), GenericParameteriser.genString(i));
        }
        gp.setParameters(props, file, true);
        System.out.println(gp.getParameters(file));
    }

    private static char genchar() {
        char c = (char)(48 + (int)(78.0 * Math.random()));
        return c;
    }

    private static String genString(int len) {
        String s = "";
        for (int i = 0; i < len; ++i) {
            s = s + GenericParameteriser.genchar();
        }
        return s;
    }
}

