/*
 * Decompiled with CFR 0.152.
 */
package utils.ssl.sslmanager.signingtools;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SHTrustManager
implements X509TrustManager {
    public static SHTrustManager INSTANCE;
    private X509TrustManager extendedTrustManager;
    private static X509TrustManager defaultTrustManager;
    private final KeyStore shKeystore;

    public static void init(KeyStore shKeystore) {
        defaultTrustManager = SHTrustManager.getDefaultTrustManager();
        INSTANCE = new SHTrustManager(shKeystore);
    }

    private static X509TrustManager getDefaultTrustManager() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                return (X509TrustManager)tm;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public SHTrustManager(KeyStore shKeystore) {
        this.shKeystore = shKeystore;
        try {
            this.reloadSHTrustManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void reloadSHTrustManager() throws KeyStoreException, NoSuchAlgorithmException {
        this.extendedTrustManager = this.getSHTrustManager(this.shKeystore);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        try {
            this.extendedTrustManager.checkClientTrusted(x509Certificates, authType);
        }
        catch (Throwable t) {
            defaultTrustManager.checkClientTrusted(x509Certificates, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        try {
            this.extendedTrustManager.checkServerTrusted(x509Certificates, authType);
        }
        catch (Throwable t) {
            defaultTrustManager.checkServerTrusted(x509Certificates, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList allCerts = new ArrayList();
        Collections.addAll(allCerts, defaultTrustManager.getAcceptedIssuers());
        Collections.addAll(allCerts, this.extendedTrustManager.getAcceptedIssuers());
        return allCerts.toArray(new X509Certificate[0]);
    }

    private X509TrustManager getSHTrustManager(KeyStore shKeyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(shKeyStore);
        System.out.println("[SHTrustManager] Initialising SH keystore with " + shKeyStore.size() + " certificates");
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }
}

