/*
 * Decompiled with CFR 0.152.
 */
package utils.ssl.sslmanager;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.util.encoders.Base64;
import utils.files.FileUtil;

public class CertificateParser {
    private static String stripHeaderAndFooter(String text) {
        if ((text = text.trim()).startsWith("---")) {
            text = text.substring(text.indexOf(10));
        }
        if (text.endsWith("---")) {
            text = text.substring(0, text.indexOf("---"));
        }
        text = text.trim();
        return text;
    }

    public static X509Certificate parseCertificate(File certificate) throws IOException, CertificateException {
        String text = FileUtil.readFileAsStringUTF8(certificate);
        text = CertificateParser.stripHeaderAndFooter(text);
        byte[] fileBytes = Base64.decode(text.getBytes());
        return CertificateParser.parseCertificate(fileBytes);
    }

    public static X509Certificate[] parseP7B(File pkcs7File) throws Exception {
        return CertificateParser.parseP7B(FileUtil.readFileAsStringUTF8(pkcs7File));
    }

    public static X509Certificate[] parseP7B(String pkcs7Text) throws Exception {
        ArrayList<X509Certificate> allCerts = new ArrayList<X509Certificate>();
        pkcs7Text = CertificateParser.stripHeaderAndFooter(pkcs7Text);
        byte[] fileBytes = Base64.decode(pkcs7Text.getBytes());
        ASN1InputStream asn1InputStream = new ASN1InputStream(fileBytes);
        ContentInfo contentInfo = ContentInfo.getInstance(asn1InputStream.readObject());
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        Enumeration certificates = signedData.getCertificates().getObjects();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        while (certificates.hasMoreElements()) {
            DERSequence certObj = (DERSequence)certificates.nextElement();
            ByteArrayInputStream in = new ByteArrayInputStream(certObj.getEncoded());
            Certificate certificate = cf.generateCertificate(in);
            X509Certificate cert = (X509Certificate)certificate;
            allCerts.add(cert);
        }
        return allCerts.toArray(new X509Certificate[0]);
    }

    public static X509Certificate parseCertificate(byte[] certificateData) throws CertificateException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(certificateData);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(asn1InputStream);
    }

    public static X509Certificate[] parseAnyCertificate(File file) {
        try {
            X509Certificate result = CertificateParser.parseCertificate(file);
            return new X509Certificate[]{result};
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                return CertificateParser.parseP7B(file);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                return null;
            }
        }
    }
}

