/*
 * Decompiled with CFR 0.152.
 */
package utils.sound.encoders.opus;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.concentus.OpusApplication;
import org.concentus.OpusDecoder;
import org.concentus.OpusEncoder;
import org.concentus.OpusException;
import org.concentus.OpusMode;
import org.concentus.OpusSignal;
import utils.progtools.time.Time;

public class OpusTest {
    private static final int BUFFER_SIZE = 128000;
    private static File soundFile;
    private static AudioInputStream audioStream;
    private static AudioFormat audioFormat;
    private static SourceDataLine sourceLine;

    public static void main(String[] args) throws Exception {
        try {
            File wav = new File("/Users/gchristelis/Desktop/piano.wav");
            AudioFormat format = null;
            try {
                AudioInputStream audioStream = AudioSystem.getAudioInputStream(wav);
                format = audioStream.getFormat();
                System.out.println(format);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            FileInputStream fileIn = new FileInputStream(wav);
            OpusEncoder encoder = new OpusEncoder(48000, 2, OpusApplication.OPUS_APPLICATION_AUDIO);
            encoder.setBitrate(32768);
            encoder.setForceMode(OpusMode.MODE_CELT_ONLY);
            encoder.setForceChannels(1);
            encoder.setSignalType(OpusSignal.OPUS_SIGNAL_AUTO);
            OpusDecoder decoder = new OpusDecoder(48000, 2);
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, format);
            SourceDataLine speakers = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
            speakers.open(format);
            speakers.start();
            ByteArrayOutputStream compressed = new ByteArrayOutputStream();
            ByteArrayOutputStream uncompressed = new ByteArrayOutputStream();
            int packetSamples = 960;
            byte[] inBuf = new byte[packetSamples * 2 * 2];
            byte[] data_packet = new byte[1275];
            long start = System.currentTimeMillis();
            short[] pcmData = new short[10000];
            long encodeTime = 0L;
            long decodeTime = 0L;
            Time t = new Time();
            while (fileIn.available() >= inBuf.length) {
                int bytesRead = fileIn.read(inBuf, 0, inBuf.length);
                pcmData = new short[bytesRead / 2];
                OpusTest.BytesToShorts(inBuf, 0, bytesRead, pcmData);
                t.lap();
                int bytesEncoded = encoder.encode(pcmData, 0, packetSamples, data_packet, 0, 1275);
                encodeTime += t.lap();
                compressed.write(data_packet, 0, bytesEncoded);
                t.lap();
                int samplesDecoded = decoder.decode(data_packet, 0, bytesEncoded, pcmData, 0, packetSamples, false);
                System.out.println("DECODED: " + samplesDecoded);
                decodeTime += t.lap();
                byte[] bytesOut = OpusTest.ShortsToBytes(pcmData);
                uncompressed.write(bytesOut, 0, bytesOut.length);
            }
            System.out.println("Total compressed size is: " + compressed.size());
            System.out.println("Total uncompressed size is: " + uncompressed.size());
            long end = System.currentTimeMillis();
            System.out.println("Time was " + (end - start) + "ms");
            System.out.println("Encode time: " + encodeTime);
            System.out.println("Decode time: " + decodeTime);
            for (int i = 0; i < 3; ++i) {
                speakers.write(uncompressed.toByteArray(), 0, uncompressed.size());
                System.out.println("HERE");
                speakers.write(uncompressed.toByteArray(), 0, uncompressed.size());
                System.out.println("HERE");
                Thread.sleep(1000L);
            }
            fileIn.close();
            System.out.println("Done!");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (OpusException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void BytesToShorts(byte[] input, int offset, int length, short[] target) {
        for (int c = 0; c < length / 2; ++c) {
            short a = (short)(input[c * 2 + offset] & 0xFF);
            short b = (short)(input[c * 2 + 1 + offset] << 8);
            target[c] = (short)(a | b);
        }
    }

    public static byte[] ShortsToBytes(short[] input) {
        return OpusTest.ShortsToBytes(input, 0, input.length);
    }

    public static byte[] ShortsToBytes(short[] input, int offset, int length) {
        byte[] processedValues = new byte[length * 2];
        for (int c = 0; c < length; ++c) {
            processedValues[c * 2] = (byte)(input[c + offset] & 0xFF);
            processedValues[c * 2 + 1] = (byte)(input[c + offset] >> 8 & 0xFF);
        }
        return processedValues;
    }

    public static void playSound(String filename) {
        String strFilename = filename;
        try {
            soundFile = new File(strFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            audioStream = AudioSystem.getAudioInputStream(soundFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        audioFormat = audioStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            sourceLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        sourceLine.start();
        int nBytesRead = 0;
        byte[] abData = new byte[128000];
        while (nBytesRead != -1) {
            try {
                nBytesRead = audioStream.read(abData, 0, abData.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (nBytesRead < 0) continue;
            int n = sourceLine.write(abData, 0, nBytesRead);
        }
        sourceLine.drain();
        sourceLine.close();
    }
}

