/*
 * Decompiled with CFR 0.152.
 */
package utils.site.transact;

import bcutil.BCUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.site.transact.SiteTransact;
import utils.string.Normaliser;

public class TrialUtil {
    public static int OK = 0;
    public static int FAIL = 1;
    public static int Q_GET_TRIAL_END = 1000;
    public static String FEATURE_BIZ = "P2Business";
    public static String FEATURE_ENT = "P2Enterprise";
    static String trialDbPage = "https://simple-help.com/dbservbeproc";
    static long DAY = 86400000L;
    File storageDir;
    File trialsDir;

    public static void main(String[] args) throws Exception {
        TrialUtil tu = new TrialUtil(new File("."));
    }

    public TrialUtil(File storageDir) {
        this.storageDir = storageDir;
        this.trialsDir = new File(storageDir, "trx");
    }

    public File getTrialsDir() {
        return this.trialsDir;
    }

    public void clearAllTrials() {
        File[] list = this.getTrialsDir().listFiles();
        if (list != null) {
            for (File file : list) {
                file.delete();
            }
        }
    }

    private Message transactCheckOK(Message m) throws IOException {
        System.out.println("[TrialUtil] Requesting - " + m);
        m = SiteTransact.doTransaction(trialDbPage, m);
        System.out.println("[TrialUtil] Response - " + m);
        if (m.getType() == FAIL) {
            String fail = m.getNextString();
            throw new IOException(fail);
        }
        return m;
    }

    private String getClientID(String email) {
        return Normaliser.normaliseToCharsAndDigits(email, true, false).replace('_', '-');
    }

    public boolean hasTrialStarted(String feature) {
        File marker = this.getLocalTrialMarkerFile(feature);
        return marker.exists();
    }

    public boolean hasTrialEnded(String feature) {
        return this.trialDaysLeft(feature) <= 0;
    }

    public boolean amTrialling(String feature) {
        return this.hasTrialStarted(feature) && !this.hasTrialEnded(feature);
    }

    public int trialDaysLeft(String feature) {
        long endDate = this.loadLocalTrialMarker(feature);
        if (endDate == -1L) {
            return 0;
        }
        long msRemaining = endDate - System.currentTimeMillis();
        long days = msRemaining / DAY;
        if (msRemaining % DAY > 0L) {
            ++days;
        }
        return Math.max(0, (int)days);
    }

    public void requestNewTrial(String feature, String email, String fullname, String companyurl, boolean forceUpdate) throws IOException {
        if (!forceUpdate) {
            long end = this.loadLocalTrialMarker(feature);
            System.out.println("[TrialUtil] Loaded load trial info for " + feature);
            if (end != -1L) {
                return;
            }
        }
        Message m = new Message(Q_GET_TRIAL_END);
        m.append(this.getClientID(email));
        m.append(feature);
        m.append(email);
        m.append(fullname);
        m.append(companyurl);
        System.out.println("[TrialUtil] No local trial stored for " + feature + " will request a new one");
        Message ret = this.transactCheckOK(m);
        long end = ret.getNextLong();
        System.out.println("[TrialUtil] New trial end date for " + feature + " is " + new Date(end) + " (" + end + ")");
        this.saveLocalTrialMarker(feature, end);
    }

    public void setRawLocalTrialMarker(String feature, byte[] dat) throws IOException {
        FileUtil.writeFile(this.getLocalTrialMarkerFile(feature), dat);
    }

    public byte[] getRawLocalTrialMarker(String feature) throws IOException {
        return FileUtil.readFile(this.getLocalTrialMarkerFile(feature));
    }

    public ArrayList<String> getTrialledFeatures() {
        File dir = this.getTrialsDir();
        File[] list = dir.listFiles();
        ArrayList<String> all = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String feature = TrialUtil.getFeatureFromTrialMarker(list[i]);
                if (feature == null) continue;
                all.add(feature);
            }
        }
        return all;
    }

    public static String getFeatureFromTrialMarker(File f) {
        String name = f.getName();
        if (name.startsWith("trxft_")) {
            return name.substring("trxft_".length());
        }
        return null;
    }

    private File getLocalTrialMarkerFile(String feature) {
        return new File(this.trialsDir, "trxft_" + feature);
    }

    private long loadLocalTrialMarker(String feature) {
        try {
            File source = this.getLocalTrialMarkerFile(feature);
            if (source.exists()) {
                byte[] enc = FileUtil.readFile(source);
                byte[] dec = BCUtil.decryptWithSecret(enc, "245316789diuAGHSFJDKAGDyiuayduihow1if4yo3ijhkSTIUY$", "hdh3kdbwfjddsddsdsr3j3ocu2io3i5u2oshs213254uthsfdgsclllp0pkmavwcewmf,", 800);
                Message m = MessageUtils.bytesToMessage(dec);
                if (!m.getNextString().equals(feature)) {
                    source.delete();
                    return -1L;
                }
                return m.getNextLong();
            }
            return -1L;
        }
        catch (Exception x) {
            x.printStackTrace();
            return -1L;
        }
    }

    public void test_DeleteLocalTrialMarker(String feature) {
        File dest = this.getLocalTrialMarkerFile(feature);
        dest.delete();
    }

    public void test_SaveLocalTrialMarker(String feature, long endDate) {
        this.saveLocalTrialMarker(feature, endDate);
    }

    private void saveLocalTrialMarker(String feature, long endDate) {
        try {
            Message m = new Message();
            m.append(feature);
            m.append(endDate);
            byte[] dec = MessageUtils.messageToBytes(m);
            byte[] enc = BCUtil.encryptWithSecret(dec, "245316789diuAGHSFJDKAGDyiuayduihow1if4yo3ijhkSTIUY$", "hdh3kdbwfjddsddsdsr3j3ocu2io3i5u2oshs213254uthsfdgsclllp0pkmavwcewmf,", 800);
            File dest = this.getLocalTrialMarkerFile(feature);
            FileUtil.writeFile(dest, enc);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

