/*
 * Decompiled with CFR 0.152.
 */
package utils.simplegraphs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import utils.simplegraphs.ColorUtil;
import utils.simplegraphs.TwinAxisModel;

public class StackedBarChart
extends JPanel {
    TwinAxisModel model;
    Color[] colors;
    Color bg = new Color(255, 255, 255, 255);
    Color bgshade = new Color(232, 232, 242);
    Color textcol = new Color(30, 30, 30);
    ColorUtil colorUtil = new ColorUtil();

    public StackedBarChart() {
        this.setOpaque(true);
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void setModel(TwinAxisModel model) {
        this.model = model;
    }

    protected Color nextColor(String key) {
        return this.colorUtil.nextColor(key);
    }

    protected void fixFontEtc(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = g.getFont().deriveFont((float)((double)this.getHeight() * 0.02));
        g.setFont(font);
    }

    @Override
    public void paint(Graphics g1d) {
        int barMaxH;
        int YSPACING;
        double lhs = 0.2;
        Graphics2D g = (Graphics2D)g1d;
        this.fixFontEtc(g);
        int HSPACING = YSPACING = (int)((double)this.getHeight() * 0.03);
        g.setColor(this.bg);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        ArrayList<String> xheads = this.model.getXHeads();
        ArrayList<String> yheads = this.model.getYHeads();
        if (this.colors == null) {
            this.colors = new Color[yheads.size()];
            for (int i = 0; i < this.colors.length; ++i) {
                this.colors[i] = this.nextColor(yheads.get(i));
            }
        }
        int kbandCount = 4;
        int keyRows = yheads.size() / kbandCount + (yheads.size() % kbandCount > 0 ? 1 : 0);
        int BMARGIN = keyRows > 1 ? (int)((double)this.getHeight() * 0.15) : (int)((double)this.getHeight() * 0.08);
        double MAX = 0.0;
        for (String xhead : xheads) {
            double sum = 0.0;
            for (String yhead : yheads) {
                sum += Math.max(0.0, this.model.get(xhead, yhead));
            }
            if (!(sum > MAX)) continue;
            MAX = sum;
        }
        int rows = xheads.size();
        int htmp = barMaxH = this.getHeight() - YSPACING * 3 - BMARGIN;
        int rowH = (htmp -= YSPACING * (rows + 1)) / rows;
        int allH = barMaxH - YSPACING * 2;
        int LMARGIN = (int)((double)this.getWidth() * 0.2);
        int rowW = this.getWidth() - HSPACING;
        int barMaxW = rowW - LMARGIN;
        double valScale = (double)barMaxW / MAX;
        int Y = YSPACING;
        g.setColor(this.bgshade);
        g.fillRect(LMARGIN + (int)((double)barMaxW * 0.25), YSPACING, (int)((double)barMaxW * 0.25), allH);
        int begin = LMARGIN + (int)((double)barMaxW * 0.75);
        int end = barMaxW;
        g.fillRect(begin, YSPACING, LMARGIN + barMaxW - begin, allH);
        int deepestPoint = 0;
        for (String xhead : xheads) {
            double prevVal = 0.0;
            int colIndex = 0;
            g.setColor(this.textcol);
            g.drawString(xhead, HSPACING, Y + rowH / 2 + g.getFontMetrics().getDescent());
            for (String yhead : yheads) {
                Color col = this.colors[colIndex++];
                g.setColor(col);
                double val = Math.max(0.0, this.model.get(xhead, yhead));
                int chunkStart = (int)(prevVal * valScale);
                int chunkEnd = (int)((prevVal + val) * valScale);
                g.fillRect(LMARGIN + chunkStart, Y, chunkEnd - chunkStart, rowH);
                deepestPoint = Y + rowH;
                prevVal += val;
            }
            Y += rowH + YSPACING;
        }
        g.setColor(this.bg);
        g.fillRect(LMARGIN - HSPACING / 2, 0, HSPACING / 2, barMaxH);
        g.fillRect(0, deepestPoint, this.getWidth(), barMaxH);
        DecimalFormat df = MAX < 2.0 ? new DecimalFormat("###,###,###,###,##0.##") : (MAX < 10.0 ? new DecimalFormat("###,###,###,###,##0.#") : new DecimalFormat("###,###,###,###,##0"));
        FontMetrics fm = g.getFontMetrics();
        int textHeight = (int)fm.getStringBounds(df.format(MAX), g).getHeight();
        g.setColor(this.textcol);
        String maxText = df.format(MAX);
        int textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
        g.drawString(maxText, LMARGIN + barMaxW - textWidth, deepestPoint + YSPACING / 2 + textHeight);
        maxText = df.format(MAX * 0.25);
        textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
        g.drawString(maxText, LMARGIN + (int)((double)barMaxW * 0.25) - textWidth / 2, deepestPoint + YSPACING / 2 + textHeight);
        maxText = df.format(MAX * 0.5);
        textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
        g.drawString(maxText, LMARGIN + (int)((double)barMaxW * 0.5) - textWidth / 2, deepestPoint + YSPACING / 2 + textHeight);
        maxText = df.format(MAX * 0.75);
        textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
        g.drawString(maxText, LMARGIN + (int)((double)barMaxW * 0.75) - textWidth / 2, deepestPoint + YSPACING / 2 + textHeight);
        maxText = this.model.zeropoint;
        textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
        g.drawString(maxText, LMARGIN, deepestPoint + YSPACING / 2 + textHeight);
        int ktop = this.getHeight() - YSPACING - BMARGIN;
        int keybandTotal = this.getWidth() - HSPACING;
        int keybandW = keybandTotal / kbandCount - HSPACING;
        int keybandH = (BMARGIN - YSPACING * (keyRows - 1)) / keyRows;
        for (int i = 0; i < yheads.size(); ++i) {
            int xpos = i % kbandCount;
            int ypos = i / kbandCount;
            g.setColor(this.colors[i]);
            int kx = HSPACING + xpos * HSPACING + xpos * keybandW;
            int ky = ktop + ypos * YSPACING + keybandH * ypos;
            g.fillRect(kx, ky, keybandW, keybandH);
            g.setColor(this.textcol);
            String text = yheads.get(i);
            while (fm.stringWidth(text) > keybandW - HSPACING && (text = text.substring(0, text.length() - 1)).length() > 3) {
            }
            g.drawString(text, kx + HSPACING / 2, ky + keybandH / 2);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        JFrame frame = new JFrame();
        StackedBarChart chart = new StackedBarChart();
        TwinAxisModel model = new TwinAxisModel();
        chart.setModel(model);
        String[] names = new String[]{"Alice", "Bob", "Cassandra", "Derek", "Gertrude", "Harry", "Ingrid", "James", "Elanor", "Antony"};
        String[] attrs = new String[]{"Height (cm)", "Age", "Jump (inches)", "Speed (m/s)", "Bravery", "Mental Fortitude", "Happiness", "Churlishness"};
        for (String name : names) {
            for (String attr : attrs) {
                model.add(name, attr, 100.0 * Math.random());
            }
        }
        frame.getContentPane().add(chart);
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 600);
        frame.setVisible(true);
        chart.repaint();
        try {
            chart.saveToPng(new File("/Users/aem/Desktop/stacked.png"), 1800, 1150);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveToPng(File file, int width, int height) throws IOException {
        this.setBounds(0, 0, width, height);
        BufferedImage img = new BufferedImage(width, height, 2);
        this.paint(img.getGraphics());
        ImageIO.write((RenderedImage)img, "PNG", file);
    }

    public byte[] toPNG(int width, int height) throws IOException {
        this.setBounds(0, 0, width, height);
        BufferedImage img = new BufferedImage(width, height, 2);
        this.paint(img.getGraphics());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "PNG", bout);
        return bout.toByteArray();
    }
}

