/*
 * Decompiled with CFR 0.152.
 */
package utils.simplegraphs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import utils.simplegraphs.ColorUtil;
import utils.simplegraphs.TimeValueModel;

public class SimpleBarGraph
extends JPanel {
    private Color backgroundColor = Color.white;
    private Color gridLinesColor = Color.white;
    private Color foregroundColor = Color.red;
    private Color fillBarColor = Color.pink;
    private Color gradientEnd = Color.red;
    private Color gradientStart = Color.blue;
    private Color[] gradientColorList = null;
    private Color foregroundColor_gray = ColorUtil.toGrayscale(Color.red);
    private Color fillBarColor_gray = ColorUtil.toGrayscale(Color.pink);
    private Color gradientEnd_gray = ColorUtil.toGrayscale(Color.red);
    private Color gradientStart_gray = ColorUtil.toGrayscale(Color.blue);
    private boolean gradientColors = true;
    private boolean grayscale = true;
    private boolean showGridLines = true;
    private long timePeriod = 30000L;
    private long startTime = System.currentTimeMillis();
    private long endTime = System.currentTimeMillis() - this.timePeriod;
    private double maxValue = 100.0;
    private double minValue = 0.0;
    private int xGridBlocks = 30;
    private int yGridBlocks = 10;
    private boolean followData = true;
    private TimeValueModel model;
    private int xBuffer = 0;
    private int yBuffer = 0;
    private int xPixelsStep;
    private int yPixelsStep;
    private int width;
    private int height;
    private String noDataString = null;
    private boolean ignoreTime = true;

    @Override
    public void paintComponent(Graphics g) {
        boolean dataAvailable;
        if (this.gradientColors && this.gradientColorList == null) {
            this.gradientColorList = new Color[this.yGridBlocks];
            for (int i = 0; i < this.yGridBlocks; ++i) {
                this.gradientColorList[i] = this.grayscale ? this.getGradientStepColor(this.gradientStart_gray, this.gradientEnd_gray, i, this.yGridBlocks) : this.getGradientStepColor(this.gradientStart, this.gradientEnd, i, this.yGridBlocks);
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.xPixelsStep = this.width / this.xGridBlocks;
        this.yPixelsStep = this.height / this.yGridBlocks;
        this.xBuffer = (this.width - this.xPixelsStep * this.xGridBlocks) / 2;
        this.yBuffer = (this.height - this.yPixelsStep * this.yGridBlocks) / 2;
        this.xPixelsStep = (this.width - 2 * this.xBuffer) / this.xGridBlocks;
        this.yPixelsStep = (this.height - 2 * this.yBuffer) / this.yGridBlocks;
        if (this.showGridLines) {
            this.drawGrids(g2d);
        }
        boolean bl = dataAvailable = this.model.getSize() > 0;
        if (!dataAvailable) {
            g2d.setColor(Color.BLACK);
            String str = "N/A";
            if (this.noDataString != null) {
                str = this.noDataString;
            }
            TextLayout tl = new TextLayout(str, g2d.getFont(), g2d.getFontRenderContext());
            Rectangle2D bounds = tl.getBounds();
            tl.draw(g2d, (float)(((double)this.width - bounds.getWidth()) / 2.0), (float)((double)(this.height / 2) + bounds.getHeight() / 2.0));
            return;
        }
        if (this.ignoreTime) {
            this.drawDataIgnoreTime(g2d);
        } else {
            this.drawData(g2d);
        }
    }

    private void drawData(Graphics2D g2d) {
        block20: {
            if (this.model == null || this.model.getSize() == 0) {
                return;
            }
            if (this.followData) {
                this.startTime = this.model.getLastTime() / 1000L * 1000L;
                this.endTime = this.startTime - this.timePeriod;
            }
            if (this.grayscale) {
                g2d.setColor(this.foregroundColor_gray);
            } else {
                g2d.setColor(this.foregroundColor);
            }
            long xDiff = this.startTime - this.endTime;
            double yDiff = this.maxValue - this.minValue;
            int previousXBlock = -1;
            double previousTotal = 0.0;
            int previousCount = 0;
            for (int index = this.model.getSize() - 1; index >= 0; --index) {
                int i;
                long time = this.model.getTime(index);
                double value = this.model.getValue(index);
                if (time < this.endTime || time > this.startTime) continue;
                double diff = time - this.endTime;
                double percentageX = diff / (double)xDiff;
                double blockPercentage = 1.0 / (double)this.xGridBlocks;
                int xBlock = (int)(percentageX / blockPercentage);
                if (previousXBlock == xBlock || previousXBlock == -1) {
                    previousXBlock = xBlock;
                    previousTotal += value;
                    ++previousCount;
                    continue;
                }
                double avgValue = previousTotal / (double)previousCount;
                diff = avgValue - this.minValue;
                double percentageY = diff / yDiff;
                blockPercentage = 1.0 / (double)this.yGridBlocks;
                int yBlock = this.yGridBlocks - (int)(percentageY / blockPercentage) - 1;
                if (this.gradientColors) {
                    this.fillBlock(g2d, previousXBlock, yBlock, this.gradientColorList[yBlock]);
                    for (i = yBlock + 1; i < this.yGridBlocks; ++i) {
                        this.fillBlock(g2d, previousXBlock, i, this.gradientColorList[i]);
                    }
                } else {
                    if (this.grayscale) {
                        this.fillBlock(g2d, previousXBlock, yBlock, this.foregroundColor_gray);
                    } else {
                        this.fillBlock(g2d, previousXBlock, yBlock, this.foregroundColor);
                    }
                    for (i = yBlock + 1; i < this.yGridBlocks; ++i) {
                        if (this.grayscale) {
                            this.fillBlock(g2d, previousXBlock, i, this.fillBarColor_gray);
                            continue;
                        }
                        this.fillBlock(g2d, previousXBlock, i, this.fillBarColor);
                    }
                }
                previousTotal = value;
                previousCount = 1;
                previousXBlock = xBlock;
            }
            if (previousXBlock == -1) break block20;
            double avgValue = previousTotal / (double)previousCount;
            double diff = avgValue - this.minValue;
            double percentageY = diff / yDiff;
            double blockPercentage = 1.0 / (double)this.yGridBlocks;
            int yBlock = this.yGridBlocks - (int)(percentageY / blockPercentage) - 1;
            if (this.gradientColors) {
                this.fillBlock(g2d, previousXBlock, yBlock, this.gradientColorList[yBlock]);
                for (int i = yBlock + 1; i < this.yGridBlocks; ++i) {
                    this.fillBlock(g2d, previousXBlock, i, this.gradientColorList[i]);
                }
            } else {
                if (this.grayscale) {
                    this.fillBlock(g2d, previousXBlock, yBlock, this.foregroundColor_gray);
                } else {
                    this.fillBlock(g2d, previousXBlock, yBlock, this.foregroundColor);
                }
                for (int i = yBlock + 1; i < this.yGridBlocks; ++i) {
                    if (this.grayscale) {
                        this.fillBlock(g2d, previousXBlock, i, this.fillBarColor_gray);
                        continue;
                    }
                    this.fillBlock(g2d, previousXBlock, i, this.fillBarColor);
                }
            }
        }
    }

    private void drawDataIgnoreTime(Graphics2D g2d) {
        if (this.model == null || this.model.getSize() == 0) {
            return;
        }
        if (this.grayscale) {
            g2d.setColor(this.foregroundColor_gray);
        } else {
            g2d.setColor(this.foregroundColor);
        }
        int xBlock = this.xGridBlocks;
        double yDiff = this.maxValue - this.minValue;
        for (int index = this.model.getSize() - 1; index >= Math.max(0, this.model.getSize() - this.xGridBlocks); --index) {
            int i;
            double value = this.model.getValue(index);
            --xBlock;
            double diff = value - this.minValue;
            double percentageY = diff / yDiff;
            double blockPercentage = 1.0 / (double)this.yGridBlocks;
            int yBlock = this.yGridBlocks - (int)(percentageY / blockPercentage) - 1;
            if (yBlock < 0) {
                yBlock = 0;
            }
            if (this.gradientColors) {
                this.fillBlock(g2d, xBlock, yBlock, this.gradientColorList[yBlock]);
                for (i = yBlock + 1; i < this.yGridBlocks; ++i) {
                    this.fillBlock(g2d, xBlock, i, this.gradientColorList[i]);
                }
                continue;
            }
            if (this.grayscale) {
                this.fillBlock(g2d, xBlock, yBlock, this.foregroundColor_gray);
            } else {
                this.fillBlock(g2d, xBlock, yBlock, this.foregroundColor);
            }
            for (i = yBlock + 1; i < this.yGridBlocks; ++i) {
                if (this.grayscale) {
                    this.fillBlock(g2d, xBlock, i, this.fillBarColor_gray);
                    continue;
                }
                this.fillBlock(g2d, xBlock, i, this.fillBarColor);
            }
        }
    }

    private Color getGradientStepColor(Color endColor, Color startColor, int step, int total) {
        if (step == 0) {
            return startColor;
        }
        if (step == total - 1) {
            return endColor;
        }
        int redDiff = endColor.getRed() - startColor.getRed();
        int greenDiff = endColor.getGreen() - startColor.getGreen();
        int blueDiff = endColor.getBlue() - startColor.getBlue();
        double perc = (double)step / (double)total;
        Color color = new Color((int)((double)startColor.getRed() + (double)redDiff * perc), (int)((double)startColor.getGreen() + (double)greenDiff * perc), (int)((double)startColor.getBlue() + (double)blueDiff * perc));
        return color;
    }

    public void fillBlock(Graphics2D g2d, int blockX, int blockY, Color fillColor) {
        g2d.setColor(fillColor);
        int x = blockX * this.xPixelsStep;
        int y = blockY * this.yPixelsStep;
        if (this.showGridLines) {
            g2d.fillRect(x + 1 + this.xBuffer, y + 1 + this.yBuffer, this.xPixelsStep - 1, this.yPixelsStep - 1);
        } else {
            g2d.fillRect(x + 1 + this.xBuffer, y + 1 + this.yBuffer, this.xPixelsStep, this.yPixelsStep);
        }
    }

    private void drawGrids(Graphics2D g2d) {
        int i;
        g2d.setColor(this.gridLinesColor);
        for (i = 1; i < this.xGridBlocks; ++i) {
            g2d.drawLine(i * this.xPixelsStep + this.xBuffer, this.yBuffer, i * this.xPixelsStep + this.xBuffer, this.height - 1 - this.yBuffer);
        }
        for (i = 1; i < this.yGridBlocks; ++i) {
            g2d.drawLine(this.xBuffer, i * this.yPixelsStep + this.yBuffer, this.width - this.xBuffer - 1, i * this.yPixelsStep + this.yBuffer);
        }
        g2d.drawRect(this.xBuffer, this.yBuffer, this.getWidth() - 1 - 2 * this.xBuffer, this.getHeight() - 1 - 2 * this.yBuffer);
    }

    public void setGrayScale(boolean grayScale) {
        this.grayscale = grayScale;
        this.gradientColorList = null;
    }

    public void setData(TimeValueModel model) {
        this.model = model;
    }

    public static void main(String[] args) throws InterruptedException {
        JFrame frame = new JFrame();
        SimpleBarGraph sbg = new SimpleBarGraph();
        TimeValueModel model = new TimeValueModel(100);
        sbg.setData(model);
        frame.getContentPane().add(sbg);
        sbg.gridLinesColor = Color.gray.brighter();
        model.addData(System.currentTimeMillis() - 3000L, 3.0);
        Thread.sleep(1000L);
        model.addData(System.currentTimeMillis() - 2000L, 30.0);
        Thread.sleep(1000L);
        model.addData(System.currentTimeMillis() - 1000L, 100.0);
        Thread.sleep(1000L);
        model.addData(System.currentTimeMillis(), 10.0);
        frame.setDefaultCloseOperation(3);
        frame.setSize(200, 200);
        frame.setVisible(true);
        sbg.repaint();
    }

    public String getNoDataString() {
        return this.noDataString;
    }

    public void setNoDataString(String noDataString) {
        this.noDataString = noDataString;
    }
}

