/*
 * Decompiled with CFR 0.152.
 */
package utils.simplegraphs;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import javax.swing.JFrame;
import utils.simplegraphs.StackedBarChart;
import utils.simplegraphs.TwinAxisModel;

public class LayeredBarChart
extends StackedBarChart {
    @Override
    public void paint(Graphics g1d) {
        int end;
        int begin;
        int barMaxH;
        int YSPACING;
        double lhs = 0.2;
        Graphics2D g = (Graphics2D)g1d;
        this.fixFontEtc(g);
        int HSPACING = YSPACING = (int)((double)this.getHeight() * 0.03);
        g.setColor(this.bg);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        ArrayList<String> xheads = this.model.getXHeads();
        ArrayList<String> yheads = this.model.getYHeads();
        if (this.colors == null) {
            this.colors = new Color[yheads.size()];
            for (int i = 0; i < this.colors.length; ++i) {
                this.colors[i] = this.nextColor(yheads.get(i));
            }
        }
        int kbandCount = 4;
        int keyRows = yheads.size() / kbandCount + (yheads.size() % kbandCount > 0 ? 1 : 0);
        int BMARGIN = keyRows > 1 ? (int)((double)this.getHeight() * 0.15) : (int)((double)this.getHeight() * 0.08);
        double MIN = 0.0;
        double MAX = 0.0;
        for (String xhead : xheads) {
            for (String yhead : yheads) {
                double val = this.model.get(xhead, yhead);
                if (val > MAX) {
                    MAX = val;
                }
                if (!(val < MIN)) continue;
                MIN = val;
            }
        }
        double MINVAL = MIN;
        System.out.println("MIN=" + MIN);
        System.out.println("MAX=" + MAX);
        MAX = Math.max(Math.abs(MIN), Math.abs(MAX));
        MIN = -MAX;
        int rows = xheads.size();
        int htmp = barMaxH = this.getHeight() - YSPACING * 3 - BMARGIN;
        int rowH = (htmp -= YSPACING * (rows + 1)) / rows;
        int allH = barMaxH - YSPACING * 2;
        int LMARGIN = (int)((double)this.getWidth() * 0.2);
        int rowW = this.getWidth() - HSPACING;
        int barMaxW = rowW - LMARGIN;
        int Y = YSPACING;
        int zeropoint = barMaxW / 2;
        if (MINVAL >= 0.0) {
            zeropoint = 0;
        }
        System.out.println("ZEROPOINT " + zeropoint);
        double negativeScale = Math.abs((double)zeropoint / MAX);
        double positiveScale = (double)(barMaxW - zeropoint) / MAX;
        g.setColor(this.bgshade);
        if (zeropoint == 0) {
            g.fillRect(LMARGIN + (int)((double)barMaxW * 0.25), YSPACING, (int)((double)barMaxW * 0.25), allH);
            begin = LMARGIN + (int)((double)barMaxW * 0.75);
            end = barMaxW;
            g.fillRect(begin, YSPACING, LMARGIN + barMaxW - begin, allH);
        } else {
            g.fillRect(LMARGIN + (int)((double)barMaxW * 0.125), YSPACING, (int)((double)barMaxW * 0.125), allH);
            int width = (int)((double)barMaxW * 0.125);
            g.fillRect(LMARGIN + zeropoint - width, YSPACING, width, allH);
            g.fillRect(LMARGIN + (int)((double)barMaxW * 0.625), YSPACING, (int)((double)barMaxW * 0.125), allH);
            begin = LMARGIN + (int)((double)barMaxW * 0.875);
            end = barMaxW;
            g.fillRect(begin, YSPACING, LMARGIN + barMaxW - begin, allH);
        }
        int deepestPoint = 0;
        boolean DEBUG = false;
        for (String xhead : xheads) {
            int chunkW;
            Color col;
            int i;
            ArrayList<Bar> negs = new ArrayList<Bar>();
            ArrayList<Bar> pozs = new ArrayList<Bar>();
            if (DEBUG) {
                System.out.println("Drawing " + xhead);
            }
            for (int i2 = 0; i2 < yheads.size(); ++i2) {
                String yhead = yheads.get(i2);
                double val = this.model.get(xhead, yhead);
                if (DEBUG) {
                    System.out.println("Vals " + i2 + ": " + val);
                }
                if (val < 0.0) {
                    negs.add(new Bar(yhead, i2, val));
                    continue;
                }
                if (!(val > 0.0)) continue;
                pozs.add(new Bar(yhead, i2, val));
            }
            Collections.sort(negs, new Comparator<Bar>(){

                @Override
                public int compare(Bar o1, Bar o2) {
                    return new Double(o1.val).compareTo(new Double(o2.val));
                }
            });
            Collections.sort(pozs, new Comparator<Bar>(){

                @Override
                public int compare(Bar o1, Bar o2) {
                    return new Double(o2.val).compareTo(new Double(o1.val));
                }
            });
            g.setColor(this.textcol);
            g.drawString(xhead, HSPACING, Y + rowH / 2 + g.getFontMetrics().getDescent());
            int divisions = yheads.size();
            for (i = 0; i < negs.size(); ++i) {
                Bar bar = (Bar)negs.get(i);
                if (DEBUG) {
                    System.out.println("Neg val: " + bar.val);
                }
                col = this.colors[bar.index];
                g.setColor(col);
                chunkW = Math.abs((int)(negativeScale * bar.val));
                g.fillRect(LMARGIN + zeropoint - chunkW, Y, chunkW, rowH / divisions * (i + 1));
            }
            for (i = 0; i < pozs.size(); ++i) {
                Bar bar = (Bar)pozs.get(i);
                if (DEBUG) {
                    System.out.println("Poz val: " + bar.val);
                }
                col = this.colors[bar.index];
                g.setColor(col);
                chunkW = Math.abs((int)(positiveScale * bar.val));
                g.fillRect(LMARGIN + zeropoint, Y, chunkW, rowH / divisions * (i + 1));
            }
            deepestPoint = Y + rowH;
            Y += rowH + YSPACING;
        }
        g.setColor(this.bg);
        g.fillRect(LMARGIN - HSPACING / 2, 0, HSPACING / 2, barMaxH);
        g.fillRect(0, deepestPoint, this.getWidth(), barMaxH);
        DecimalFormat df = MAX < 2.0 ? new DecimalFormat("###,###,###,###,##0.##") : (MAX < 10.0 ? new DecimalFormat("###,###,###,###,##0.#") : new DecimalFormat("###,###,###,###,##0"));
        FontMetrics fm = g.getFontMetrics();
        int textHeight = (int)fm.getStringBounds(df.format(MAX), g).getHeight();
        g.setColor(this.textcol);
        String maxText = df.format(MAX);
        int textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
        g.drawString(maxText, LMARGIN + barMaxW - textWidth, deepestPoint + YSPACING / 2 + textHeight);
        if (zeropoint == 0) {
            maxText = df.format(MAX / 2.0);
            textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
            g.drawString(maxText, LMARGIN + (int)((double)barMaxW * 0.5) - textWidth / 2, deepestPoint + YSPACING / 2 + textHeight);
            maxText = this.model.zeropoint;
            textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
            g.drawString(maxText, LMARGIN, deepestPoint + YSPACING / 2 + textHeight);
        } else {
            maxText = this.model.zeropoint;
            textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
            g.drawString(maxText, LMARGIN + (int)((double)barMaxW * 0.5) - textWidth / 2, deepestPoint + YSPACING / 2 + textHeight);
            maxText = df.format(MIN);
            textWidth = (int)fm.getStringBounds(maxText, g).getWidth();
            g.drawString(maxText, LMARGIN, deepestPoint + YSPACING / 2 + textHeight);
        }
        int ktop = this.getHeight() - YSPACING - BMARGIN;
        int keybandTotal = this.getWidth() - HSPACING;
        int keybandW = keybandTotal / kbandCount - HSPACING;
        int keybandH = (BMARGIN - YSPACING * (keyRows - 1)) / keyRows;
        for (int i = 0; i < yheads.size(); ++i) {
            int xpos = i % kbandCount;
            int ypos = i / kbandCount;
            g.setColor(this.colors[i]);
            int kx = HSPACING + xpos * HSPACING + xpos * keybandW;
            int ky = ktop + ypos * YSPACING + keybandH * ypos;
            g.fillRect(kx, ky, keybandW, keybandH);
            g.setColor(this.textcol);
            String text = yheads.get(i);
            while (fm.stringWidth(text) > keybandW - HSPACING && (text = text.substring(0, text.length() - 1)).length() > 3) {
            }
            g.drawString(text, kx + HSPACING / 2, ky + keybandH / 2);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        JFrame frame = new JFrame();
        LayeredBarChart chart = new LayeredBarChart();
        TwinAxisModel model = new TwinAxisModel();
        chart.setModel(model);
        String[] names = new String[]{"Alice", "Bob", "Cassandra", "Derek", "Gertrude", "Harry", "Ingrid", "James", "Elanor", "Antony"};
        String[] attrs = new String[]{"Access", "Support", "Demo"};
        Random r = new Random(System.currentTimeMillis());
        boolean allNegativeOrPositive = false;
        for (String name : names) {
            boolean negative = r.nextBoolean();
            for (String attr : attrs) {
                double val;
                if (allNegativeOrPositive) {
                    val = negative ? (double)(-r.nextInt(100)) : (double)r.nextInt(100);
                } else {
                    val = 200.0 * Math.random() - 100.0;
                    while (val > -15.0 && val < 15.0) {
                        val = 200.0 * Math.random() - 100.0;
                    }
                }
                model.add(name, attr, val);
            }
        }
        frame.getContentPane().add(chart);
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 600);
        frame.setVisible(true);
        chart.repaint();
        try {
            chart.saveToPng(new File("/Users/aem/Desktop/layered.png"), 1800, 1150);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Bar {
        String yhead;
        int index;
        double val;

        public Bar(String yhead, int index, double val) {
            this.yhead = yhead;
            this.index = index;
            this.val = val;
        }
    }
}

