/*
 * Decompiled with CFR 0.152.
 */
package utils.radius;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLException;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.EAPAuthenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import utils.radius.SHEAPTLSAuthenticator;

public class SHPEAPAuthenticator
extends SHEAPTLSAuthenticator {
    public static final String NAME = "peap";
    private EAPAuthenticator tunnelAuth;
    private RadiusPacket tunnelRequest;

    public SHPEAPAuthenticator() {
        this.setEAPType(25);
    }

    @Override
    public void init() throws RadiusException {
        super.init();
        this.tunnelAuth = new EAPMSCHAPv2Authenticator(true);
    }

    @Override
    public String getAuthName() {
        return NAME;
    }

    @Override
    protected boolean isCertificateRequired() {
        return false;
    }

    @Override
    public void setupRequest(RadiusClient c, RadiusPacket p) throws RadiusException {
        super.setupRequest(c, p);
        this.tunnelRequest = new AccessRequest();
        AttributeList attrs = this.tunnelRequest.getAttributes();
        if (attrs.get(1L) == null) {
            attrs.add(this.username);
        }
        if (attrs.get(2L) == null) {
            attrs.add(this.password);
        }
        this.tunnelAuth.setupRequest(c, this.tunnelRequest);
        this.tunnelAuth.processRequest(this.tunnelRequest);
    }

    @Override
    protected boolean doTunnelAuthentication(byte id, byte[] in) throws RadiusException, SSLException {
        byte[] out = null;
        if (in != null && in.length > 0) {
            out = this.tunnelAuth.doEAP(in);
        } else {
            Method method = null;
            try {
                method = EAPAuthenticator.class.getDeclaredMethod("eapResponse", Integer.TYPE, Byte.TYPE, byte[].class);
                method.setAccessible(true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                out = (byte[])method.invoke((Object)this.tunnelAuth, 1, (byte)0, this.getUsername());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.putAppBuffer(out);
        return true;
    }
}

