/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.streams;

import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    byte[] dat;
    int datlen;
    int pos;

    public FastByteArrayInputStream(byte[] b) {
        this.dat = b;
        this.datlen = this.dat.length;
        this.pos = 0;
    }

    @Override
    public int read() {
        if (this.pos == this.datlen) {
            return -1;
        }
        return this.dat[this.pos++];
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int newpos) {
        if (newpos < 0 || newpos >= this.datlen) {
            throw new ArrayIndexOutOfBoundsException("specified position " + newpos + " is out of bounds for array (0-" + this.datlen + ")");
        }
        this.pos = newpos;
    }
}

