/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.resume;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.clock.AltClock;
import utils.progtools.clock.TimingAltClock;
import utils.progtools.resume.ThreadCreateCallback;
import utils.progtools.resume.ThreadCreateNotifier;
import utils.switches.Switches;

public class TccMap {
    public static int TCC_MAP_STATUS_FREQUENCY = -1;
    Object timeouts_LOCK = new Object();
    LinkedList timeouts = new LinkedList();
    AltClock clock;
    OnDemandThreadPool odp = new OnDemandThreadPool("TccMapPool", Switches.SH_1778_largerTccMapPool ? Switches.SH_1778_tccMapPoolSize : (Switches.SH_1595_largeTccMapPool ? 600 : 150), Switches.SH_1778_largerTccMapPool ? Switches.SH_1778_tccMapBufferCount : 10000, 10);
    boolean ttOn = false;
    TimeoutThread tt;
    long lastStatus = 0L;

    public TccMap(AltClock clock) {
        this.clock = clock;
    }

    public TccMap() {
        this.clock = new TimingAltClock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadOn() {
        Object object = this.timeouts_LOCK;
        synchronized (object) {
            if (!this.ttOn) {
                this.ttOn = true;
                this.tt = new TimeoutThread();
                this.tt.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadOff() {
        Object object = this.timeouts_LOCK;
        synchronized (object) {
            if (this.ttOn) {
                this.ttOn = false;
                if (this.tt != null) {
                    this.tt.die = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadCreateNotifier doResumableWait(ThreadCreateCallback callback, long timeout) {
        ThreadCreateNotifier tcn = new ThreadCreateNotifier(this, callback, timeout, callback.getTccThreadGroup(), this.odp);
        Object object = this.timeouts_LOCK;
        synchronized (object) {
            this.timeouts.add(tcn);
            this.threadOn();
        }
        return tcn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTimeoutsAndFired() {
        ArrayList<ThreadCreateNotifier> timedOut = new ArrayList<ThreadCreateNotifier>();
        Object object = this.timeouts_LOCK;
        synchronized (object) {
            long T = System.currentTimeMillis();
            ListIterator it = this.timeouts.listIterator();
            while (it.hasNext()) {
                ThreadCreateNotifier tcn = (ThreadCreateNotifier)it.next();
                if (tcn.hasFired()) {
                    it.remove();
                    continue;
                }
                if (!tcn.hasTimedOut(T)) continue;
                it.remove();
                timedOut.add(tcn);
            }
            if (this.timeouts.isEmpty()) {
                this.threadOff();
            }
            if (TCC_MAP_STATUS_FREQUENCY != -1 && this.clock.getTime() - this.lastStatus > (long)TCC_MAP_STATUS_FREQUENCY) {
                this.printStatus();
            }
        }
        for (int i = 0; i < timedOut.size(); ++i) {
            ThreadCreateNotifier tcn = (ThreadCreateNotifier)timedOut.get(i);
            tcn.fireTimedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatus() {
        Object object = this.timeouts_LOCK;
        synchronized (object) {
            System.out.println("[TCC] " + this.timeouts.size() + " threads resumable, " + this.odp.getLiveCount() + " threads processing");
            this.lastStatus = this.clock.getTime();
        }
    }

    class TimeoutThread
    extends Thread {
        boolean die = false;

        TimeoutThread() {
        }

        @Override
        public void run() {
            while (!this.die) {
                try {
                    if (Switches.SH_1839_tccMapLessGranularTimeouts) {
                        Thread.sleep(1250L);
                    } else {
                        Thread.sleep(500L);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.die) {
                    return;
                }
                try {
                    TccMap.this.clearTimeoutsAndFired();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

