/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.profiler;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import utils.progtools.Counter;
import utils.progtools.MTCounter;
import utils.progtools.clock.TimingClock;

public class SamplingProfiler {
    static String[] bad = new String[]{"InputStream.read", ".Object.wait", ".Object.notify", ".read0", ".receive0", "DatagramSocketImpl.send", ".socketAccept", ".socketWrite0", "Thread.dumpThreads", "Thread.sleep", "accept0", "ServerSocketChannelImpl.accept", "SelectorImpl.select", "sun.misc.Unsafe.park"};
    Counter counter = new MTCounter();
    long mswait;
    SamplerThread st;
    long started = 0L;
    long ended = 0L;
    long samples;

    public static void clearIoExceptions() {
        bad = new String[0];
    }

    public static void addIoException(String substringMatch) {
        String[] tmp = new String[bad.length + 1];
        System.arraycopy(bad, 0, tmp, 0, bad.length);
        tmp[SamplingProfiler.bad.length] = substringMatch;
    }

    public static String[] getIoExceptions() {
        return bad;
    }

    public void dump(double minPercent) {
        this.dump(minPercent, null);
    }

    public void dump(double minPercent, String match) {
        System.out.println(this.dumpToString(minPercent, match));
    }

    public String dumpToString(double minPercent) {
        return this.dumpToString(minPercent, null);
    }

    public String dumpToString(double minPercent, String match) {
        StringBuffer sb = new StringBuffer();
        if (match == null) {
            match = "";
        }
        this.counter.sortByValue(true);
        ArrayList keys = this.counter.getSortedKeys();
        double tot = 0.0;
        for (Object key : keys) {
            if (!key.toString().contains(match)) continue;
            tot += (double)this.counter.getInt(key);
        }
        DecimalFormat df = new DecimalFormat("#00.00");
        double percent = 100.0 / tot;
        for (Object key : keys) {
            double count = this.counter.getInt(key);
            if (!((count *= percent) > minPercent) || !key.toString().contains(match)) continue;
            sb.append(df.format(count) + "% - " + key).append('\n');
        }
        long timeRanFor = this.ended - this.started;
        if (this.ended == 0L) {
            timeRanFor = TimingClock.currentTimeMillis() - this.started;
        }
        long expectedSamples = timeRanFor / this.mswait;
        long actualSamples = this.samples;
        double spercent = 100.0 / (double)expectedSamples;
        sb.append("Actual samples: " + actualSamples + " (vs expected " + expectedSamples + ") over " + timeRanFor + "ms\n");
        sb.append("Rough accuracy: " + (int)(spercent *= (double)actualSamples) + "%\n");
        return sb.toString();
    }

    private void doSample() {
        Object[] keys;
        ++this.samples;
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Object key : keys = map.keySet().toArray()) {
            StackTraceElement[] elems;
            Thread th = (Thread)key;
            if (th.getState() != Thread.State.RUNNABLE) continue;
            String methods = "";
            for (StackTraceElement elem : elems = map.get(th)) {
                if (methods.length() > 0) {
                    methods = methods + " <- ";
                }
                methods = methods + elem.getClassName() + "." + elem.getMethodName() + ":" + elem.getLineNumber();
            }
            if (methods.trim().length() == 0) continue;
            boolean ignore = false;
            for (String check : bad) {
                if (!methods.contains(check)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            this.counter.add(methods, 1.0);
        }
    }

    public void startSampling(int samplesPerSecond) {
        this.stopSampling();
        this.mswait = Math.max(1, 1000 / samplesPerSecond);
        this.started = TimingClock.currentTimeMillis();
        this.samples = 0L;
        this.ended = 0L;
        this.st = new SamplerThread();
        this.st.start();
    }

    public void stopSampling() {
        this.ended = TimingClock.currentTimeMillis();
        if (this.st != null) {
            this.st.die = true;
            this.st = null;
        }
    }

    public static void main(String[] args) throws Exception {
        SamplingProfiler sampler = new SamplingProfiler();
        sampler.startSampling(50);
        long ITS = 0L;
        long T = System.currentTimeMillis();
        while (System.currentTimeMillis() <= T + 5000L) {
            ++ITS;
        }
        DecimalFormat df = new DecimalFormat("###,###,###,###,###");
        System.out.println("Iterations: " + df.format(ITS));
        sampler.stopSampling();
        sampler.dump(1.0);
    }

    class SamplerThread
    extends Thread {
        boolean die = false;

        public SamplerThread() {
            this.setPriority(10);
        }

        @Override
        public void run() {
            while (!this.die) {
                SamplingProfiler.this.doSample();
                try {
                    Thread.sleep(SamplingProfiler.this.mswait);
                }
                catch (Exception exception) {}
            }
        }
    }
}

