/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.net;

import java.net.MalformedURLException;
import java.net.URL;

public class URLParser {
    private String connectHostname = null;
    private int connectPort = -1;
    private String protocol = null;
    private int defaultPort = -1;
    private String defaultProtocol = "http";
    private String query;
    private String path;

    public URLParser(String url) {
        try {
            URL uri = new URL(url);
            this.connectHostname = uri.getHost();
            this.protocol = uri.getProtocol();
            this.path = uri.getPath();
            this.query = uri.getQuery();
            if (!url.contains("://")) {
                this.protocol = null;
            }
            if (uri.getPort() != -1) {
                this.connectPort = uri.getPort();
            } else {
                this.defaultPort = this.protocol == null ? 80 : (this.protocol.equalsIgnoreCase("https") ? 443 : 80);
            }
        }
        catch (Throwable t) {
            int portIndex;
            int queryIndex = url.indexOf(63);
            if (queryIndex != -1) {
                this.query = url.substring(queryIndex + 1);
                url = url.substring(0, queryIndex);
            }
            if (url.startsWith("/")) {
                this.connectHostname = null;
                this.defaultPort = -1;
                this.protocol = null;
                this.path = url;
            }
            int doubleSlash = url.indexOf("://");
            int lastSlash = url.indexOf(47, doubleSlash + 3);
            if (lastSlash != -1) {
                url = url.substring(0, lastSlash);
            }
            if (doubleSlash != -1) {
                this.protocol = url.substring(0, doubleSlash);
                url = url.substring(doubleSlash + 3, url.length());
            }
            if ((portIndex = url.indexOf(58)) == -1) {
                this.connectHostname = url;
                this.defaultPort = this.protocol == null ? 80 : (this.protocol.equalsIgnoreCase("https") ? 443 : 80);
                return;
            }
            this.connectHostname = url.substring(0, portIndex);
            this.connectPort = Integer.parseInt(url.substring(portIndex + 1));
        }
    }

    public String getHostname() {
        return this.connectHostname;
    }

    public int getPort(boolean returnDefaultIfNull) {
        if (this.connectPort != -1) {
            return this.connectPort;
        }
        if (returnDefaultIfNull) {
            return this.defaultPort;
        }
        return -1;
    }

    public String getProtocol(boolean returnDefaultIfNull) {
        if (this.protocol != null) {
            return this.protocol;
        }
        if (returnDefaultIfNull) {
            return this.defaultProtocol;
        }
        return null;
    }

    public String toString() {
        return "[" + this.protocol + "]://[" + this.connectHostname + "]:[" + this.connectPort + "][" + this.path + "]?[" + this.query + "]";
    }

    public boolean isHTTP() {
        return this.getProtocol(true).toLowerCase().equals("http");
    }

    public boolean isHTTPS() {
        return this.getProtocol(true).toLowerCase().equals("https");
    }

    public static void main(String[] args) throws MalformedURLException {
        System.out.println(new URLParser("/files/main_style.css?1429473249"));
        System.out.println(new URLParser("http://google.com"));
        System.out.println(new URLParser("https://google.com"));
        System.out.println(new URLParser("google.com"));
        System.out.println(new URLParser("https://google.com:123"));
        System.out.println(new URLParser("http://google.com:123"));
        System.out.println(new URLParser("google.com:80"));
        System.out.println(new URLParser("http://google.com").getBestGuessURL());
        System.out.println(new URLParser("https://google.com").getBestGuessURL());
        System.out.println(new URLParser("google.com").getBestGuessURL());
        System.out.println(new URLParser("https://google.com:123").getBestGuessURL());
        System.out.println(new URLParser("http://google.com:123").getBestGuessURL());
        System.out.println(new URLParser("google.com:80").getBestGuessURL());
        System.out.println(new URLParser("http://google.com/this/is/a/test?123=xa&123=222").getBestGuessURL());
        URLParser urlParser = new URLParser("google.com");
        System.out.println(urlParser.getPort(false) + " " + urlParser.getPort(true));
        System.out.println(urlParser.getProtocol(false) + " " + urlParser.getProtocol(true));
        URLParser urlParser2 = new URLParser("http://google.com?test=${George}&value=${WOOT}");
        System.out.println(urlParser2.getBestGuessURL());
    }

    public URL getBestGuessURL() throws MalformedURLException {
        boolean hasQuery;
        String url = this.getProtocol(true) + "://" + this.getHostname();
        if (this.isHTTP() && this.getPort(true) != 80 || this.isHTTPS() && this.getPort(true) != 443 || !this.isHTTP() && !this.isHTTPS()) {
            url = url + ":" + this.connectPort;
        }
        boolean hasPath = this.path != null && this.path.length() > 0;
        boolean bl = hasQuery = this.query != null && this.query.length() > 0;
        if (hasPath) {
            if (!url.endsWith("/") && !this.path.startsWith("/")) {
                url = url + "/";
            }
            url = url + this.path;
        }
        if (hasQuery) {
            if (!url.endsWith("?") && !this.query.startsWith("?")) {
                url = url + "?";
            }
            url = url + this.query;
        }
        return new URL(url);
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPort(int port) {
        this.connectPort = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

