/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.date;

import java.util.Calendar;

public class DateUtil {
    public static int getDaysBetween(long startTime, long endTime) {
        long diff = Math.abs(endTime - startTime);
        if ((diff = diff / 1000L / 60L / 60L / 24L) > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)diff;
    }

    public static long oneYearAgo() {
        return DateUtil.nYearsAgo(1);
    }

    public static long nYearsAgo(int n) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        c.roll(1, -n);
        return c.getTimeInMillis();
    }

    public static int getYearsBetween(long startTime, long endTime) {
        return DateUtil.getDaysBetween(startTime, endTime) / 365;
    }

    public static long addYearTo(long timeMS) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMS);
        c.roll(1, true);
        return c.getTimeInMillis();
    }
}

