/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public class SortedList<E>
implements List<E> {
    private ArrayList<E> elements = new ArrayList();
    private Comparator<E> comparator;

    public SortedList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public SortedList() {
        this.comparator = new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    public static void main(String[] args) {
        SortedList<Integer> list = new SortedList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            Random r = new Random();
            list.add(Math.abs(r.nextInt()));
        }
        for (Integer i : list) {
            System.out.println(i);
        }
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.comparator.compare(e, this.elements.get(i)) > 0) continue;
            this.elements.add(i, e);
            return true;
        }
        this.elements.add(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public E get(int index) {
        return this.elements.get(index);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        return this.elements.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }
}

