/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.arrays;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;

public class ArrayUtils {
    public static <T> boolean contains(T[] elements, T item) {
        return ArrayUtils.indexOf(elements, item) >= 0;
    }

    public static <T> int indexOf(T[] elements, T item) {
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        int totalLen = first.length + second.length;
        Object[] all = (Object[])Array.newInstance(first.getClass().getComponentType(), totalLen);
        System.arraycopy(first, 0, all, 0, first.length);
        System.arraycopy(second, 0, all, first.length, second.length);
        return all;
    }

    public static <T> T[] concat(T[][] arrays) {
        if (arrays == null) {
            return null;
        }
        int totalLen = 0;
        for (T[] array : arrays) {
            totalLen += array.length;
        }
        Object[] all = (Object[])Array.newInstance(arrays.getClass().getComponentType().getComponentType(), totalLen);
        int length = 0;
        for (T[] arr : arrays) {
            System.arraycopy(arr, 0, all, length, arr.length);
            length += arr.length;
        }
        return all;
    }

    public static String[] pop(String[] orig, int index) {
        String[] tmp = new String[orig.length - 1];
        int N = 0;
        for (int i = 0; i < orig.length; ++i) {
            if (i == index) continue;
            tmp[N++] = orig[i];
        }
        return tmp;
    }

    public static boolean contains(int[] array, int element) {
        if (array == null) {
            return false;
        }
        for (int anArray : array) {
            if (anArray != element) continue;
            return true;
        }
        return false;
    }

    public static String[] popFirst(String[] orig) {
        return ArrayUtils.subArray(orig, 1, orig.length - 1);
    }

    public static String[] subArray(String[] orig, int index, int len) {
        String[] tmp = new String[len];
        System.arraycopy(orig, index, tmp, 0, len);
        return tmp;
    }

    public static byte[] subArray(byte[] orig, int index, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(orig, index, tmp, 0, len);
        return tmp;
    }

    public static <T> ArrayList<T> toList(T[] array) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, array);
        return list;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        Object[] copy = original.getClass() == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(original.getClass().getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <E> void printArray(E[] inputArray) {
        for (E element : inputArray) {
            System.out.printf("%s ", element);
        }
        System.out.println();
    }

    public static <E> E[] reverse(E[] list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length / 2; ++i) {
            E tmp = list[i];
            list[i] = list[list.length - 1 - i];
            list[list.length - 1 - i] = tmp;
        }
        return list;
    }
}

