/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import utils.progtools.Counter;
import utils.progtools.MapOfLists;

public class StackDumper {
    public static void main(String[] args) {
        StackDumper.dumpCondensedCompleteThreadStacks();
    }

    public static void dumpCondensedCompleteThreadStacks() {
        StackDumper.dumpCondensedCompleteThreadStacks(null);
    }

    public static void dumpCondensedCompleteThreadStacks(File save) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintStream pout = new PrintStream(bout);
            Method method = Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)method.invoke(null, new Object[0]);
            Thread[] threadKeys = map.keySet().toArray(new Thread[0]);
            pout.println("[AllThreadsTrace] Full Thread Trace Printout " + new Date());
            pout.println("[AllThreadsTrace] Total Threads: x" + threadKeys.length);
            MapOfLists<String, Thread> byTrace = new MapOfLists<String, Thread>(true);
            Counter<String> sorter = new Counter<String>();
            for (Thread th : threadKeys) {
                StackTraceElement[] stack = (StackTraceElement[])map.get(th);
                StringBuilder stacks = new StringBuilder();
                for (StackTraceElement aStack : stack) {
                    stacks.append("\tat ").append(aStack).append("\n");
                }
                String tstak = stacks.toString();
                byTrace.add(tstak, th);
                sorter.add(tstak, 1.0);
            }
            sorter.sortByValue(false);
            ArrayList keylist = sorter.getSortedKeys();
            for (String tstak : keylist) {
                List all = byTrace.get(tstak);
                pout.println();
                pout.println("[AllThreadsTrace] " + all.size() + "x threads with trace:");
                pout.println(tstak);
                pout.println("   Thread Names:");
                Collections.sort(all, new Comparator<Thread>(){

                    @Override
                    public int compare(Thread o1, Thread o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (int k = 0; k < all.size(); ++k) {
                    Thread th = (Thread)all.get(k);
                    if (k == 0) {
                        pout.print("   ");
                    } else if (k % 3 == 0) {
                        pout.println();
                        pout.print("   ");
                    }
                    pout.print(th.getName() + " (" + (Object)((Object)th.getState()) + "),");
                }
                pout.println();
            }
            pout.flush();
            String text = new String(bout.toByteArray());
            System.out.println(text);
            if (save != null) {
                FileOutputStream fout = new FileOutputStream(save);
                fout.write(bout.toByteArray());
                fout.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

